/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

import com.exasol.errorreporting.ErrorMessageBuilder;
import com.exasol.errorreporting.Placeholder;
import com.exasol.errorreporting.PlaceholderMatcher;

class ParametersMapper {
    private final String text;
    private final Object[] parameters;
    private int parameterIndex;
    private final ErrorMessageBuilder errorMessageBuilder;

    static void mapParametersByName(String text, Object[] parameters, ErrorMessageBuilder errorMessageBuilder) {
        new ParametersMapper(text, parameters, errorMessageBuilder).mapParameters();
    }

    private ParametersMapper(String text, Object[] arguments, ErrorMessageBuilder errorMessageBuilder) {
        this.parameters = arguments;
        this.parameterIndex = 0;
        this.errorMessageBuilder = errorMessageBuilder;
        this.text = text;
    }

    private void mapParameters() {
        Iterable<Placeholder> placeholders = PlaceholderMatcher.findPlaceholders(this.text);
        for (Placeholder placeholder : placeholders) {
            this.mapParameter(placeholder);
            this.moveToNextParameter();
        }
    }

    private void mapParameter(Placeholder placeholder) {
        if (this.isParameterPresent()) {
            this.appendParameter(placeholder);
        }
    }

    private boolean isParameterPresent() {
        return this.parameters != null && this.parameterIndex < this.parameters.length;
    }

    private void appendParameter(Placeholder placeholder) {
        if (this.isNullParameter()) {
            this.appendNullParameter(placeholder.getReference());
        } else {
            this.appendRegularParameter(placeholder);
        }
    }

    private boolean isNullParameter() {
        return this.isParameterPresent() && this.getCurrentParameter() == null;
    }

    private void appendNullParameter(String parameterName) {
        this.errorMessageBuilder.parameter(parameterName, null);
    }

    private void appendRegularParameter(Placeholder placeholder) {
        this.errorMessageBuilder.parameter(placeholder.getReference(), this.getCurrentParameter());
    }

    private Object getCurrentParameter() {
        if (this.isParameterPresent()) {
            return this.parameters[this.parameterIndex];
        }
        return null;
    }

    private void moveToNextParameter() {
        ++this.parameterIndex;
    }
}

