/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Star;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.DecelerateInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import com.example.mzy.indicators.Star.StarModel;
import com.example.mzy.indicators.Star.VertexF;
import java.util.ArrayList;

public class StarIndicator
extends IndicatorDrawable {
    private static final float THICKNESS = 0.7f;
    private final String TAG = StarIndicator.class.getSimpleName();
    private float starHeight;
    private StarModel mStarModel = new StarModel(0.7f);
    private CornerPathEffect pathEffect = new CornerPathEffect(30.0f);
    private float mAnimatedValue;
    private RectF mShadowRect = new RectF();
    private float mShadowWidth;

    public StarIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"StarIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 2000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(StarIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                StarIndicator.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                StarIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration((long)this.indicatorSpeed);
        list.add((Animator)valueAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.starHeight == 0.0f) {
            this.starHeight = this.getWidth() / 5;
            this.mStarModel.setDrawingOuterRect(0.0f, 0.0f, this.starHeight);
            this.mShadowWidth = this.getWidth() / 5;
        }
        canvas.save();
        float x = (float)(this.getWidth() / 2) - this.starHeight / 2.0f;
        float value = (double)this.mAnimatedValue <= 0.5 ? this.mAnimatedValue : 1.0f - this.mAnimatedValue;
        canvas.translate(x, (float)(this.getHeight() / 4) + value * this.starHeight);
        canvas.rotate(360.0f * this.mAnimatedValue, this.starHeight / 2.0f, this.starHeight / 2.0f);
        this.drawStar(canvas, paint);
        canvas.restore();
        this.drawShadow(canvas, paint);
    }

    private void drawStar(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setPathEffect((PathEffect)this.pathEffect);
        paint.setColor(this.indicatorColor);
        VertexF prev = this.mStarModel.getVertex(1);
        Path path = new Path();
        for (int i = 0; i < 5; ++i) {
            path.rewind();
            path.moveTo(prev.x, prev.y);
            VertexF next = prev.next;
            path.lineTo(next.x, next.y);
            path.lineTo(next.next.x, next.next.y);
            canvas.drawPath(path, paint);
            prev = next.next;
        }
        path.rewind();
        prev = this.mStarModel.getVertex(1);
        path.moveTo(prev.x - 1.0f, prev.y - 1.0f);
        prev = prev.next.next;
        path.lineTo(prev.x + 1.5f, prev.y - 0.5f);
        prev = prev.next.next;
        path.lineTo(prev.x + 1.5f, prev.y + 1.0f);
        prev = prev.next.next;
        path.lineTo(prev.x, prev.y + 1.0f);
        prev = prev.next.next;
        path.lineTo(prev.x - 1.0f, prev.y + 1.0f);
        paint.setPathEffect(null);
        canvas.drawPath(path, paint);
    }

    private void drawShadow(Canvas canvas, Paint paint) {
        paint.setColor(-7829368);
        float value = (double)this.mAnimatedValue <= 0.5 ? this.mAnimatedValue : 1.0f - this.mAnimatedValue;
        if ((double)value < 0.1) {
            return;
        }
        float cut = this.mShadowWidth * value * 0.7f;
        float y = (float)(this.getHeight() / 4) + 0.5f * this.starHeight + this.starHeight;
        this.mShadowRect.set((float)(this.getWidth() / 2) - cut, y + this.mShadowWidth / 8.0f, (float)(this.getWidth() / 2) + cut, y + this.mShadowWidth / 4.0f);
        canvas.drawOval(this.mShadowRect, paint);
    }
}

