/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class CircleRotateScaleIndicator
extends IndicatorDrawable {
    private final String TAG = CircleRotateScaleIndicator.class.getSimpleName();
    private final int mCount = 5;
    private float mAnimatedValue = 0.0f;
    private float[] scaleAnimatedValue = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private boolean drawAssist = false;

    public CircleRotateScaleIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"CircleRotateScaleIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 2000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(CircleRotateScaleIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator rotateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        rotateAnimator.setRepeatCount(-1);
        rotateAnimator.setDuration((long)this.indicatorSpeed);
        rotateAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircleRotateScaleIndicator.this.mAnimatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                CircleRotateScaleIndicator.this.invalidateSelf();
            }
        });
        int[] delays = new int[]{0, 100, 200, 300, 400};
        for (int i = 0; i < 5; ++i) {
            final int index = i;
            ValueAnimator scaleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.4f, 1.0f});
            scaleAnimator.setDuration((long)this.indicatorSpeed);
            scaleAnimator.setRepeatCount(-1);
            scaleAnimator.setStartDelay((long)delays[i]);
            scaleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((CircleRotateScaleIndicator)CircleRotateScaleIndicator.this).scaleAnimatedValue[index] = ((Float)animation.getAnimatedValue()).floatValue();
                }
            });
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{rotateAnimator, scaleAnimator});
            list.add((Animator)animatorSet);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        canvas.save();
        this.drawAssist(canvas, paint);
        this.drawBall(canvas, paint);
        canvas.restore();
    }

    private void drawAssist(Canvas canvas, Paint paint) {
        if (this.drawAssist) {
            canvas.drawColor(-65536);
            canvas.drawLine((float)(this.getWidth() / 2), 0.0f, (float)(this.getWidth() / 2), (float)this.getHeight(), paint);
            canvas.drawLine(0.0f, (float)(this.getHeight() / 2), (float)this.getWidth(), (float)(this.getHeight() / 2), paint);
        }
    }

    private void drawBall(Canvas canvas, Paint paint) {
        float out_radius = this.getWidth() / 10;
        float radius = this.getWidth() / 25;
        for (int i = 0; i < 5; ++i) {
            int degree = (int)((float)(72 * i) + this.mAnimatedValue);
            double angle = (double)degree * Math.PI / 180.0;
            float x = (float)(this.getWidth() / 2) + out_radius * (float)Math.cos(angle);
            float y = (float)(this.getHeight() / 2) + out_radius * (float)Math.sin(angle);
            canvas.drawCircle(x, y, radius * this.scaleAnimatedValue[i], paint);
        }
    }
}

