/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.ArrayList;

public abstract class IndicatorDrawable
extends Drawable
implements Animatable {
    private final String TAG = IndicatorDrawable.class.getSimpleName();
    private ArrayList<Animator> mAnimatorsList;
    private Rect mBounds = new Rect();
    protected Paint mPaint = new Paint();

    protected abstract void init(Context var1);

    protected abstract ArrayList<Animator> getAnimation();

    protected abstract void draw(Canvas var1, Paint var2);

    public int getAlpha() {
        return super.getAlpha();
    }

    public void setAlpha(int alpha) {
    }

    public ColorFilter getColorFilter() {
        return super.getColorFilter();
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -1;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mBounds.set(bounds);
    }

    protected int getWidth() {
        return this.mBounds.width();
    }

    protected int getHeight() {
        return this.mBounds.height();
    }

    public void draw(Canvas canvas) {
        this.draw(canvas, this.mPaint);
    }

    public void start() {
        if (this.mAnimatorsList == null) {
            this.mAnimatorsList = this.getAnimation();
        }
        if (this.mAnimatorsList != null) {
            this.startAnimation();
        } else {
            Log.d((String)this.TAG, (String)"start: mAnimatorsList is null.");
        }
    }

    public void stop() {
        if (this.mAnimatorsList != null) {
            this.stopAnimation();
        } else {
            Log.d((String)this.TAG, (String)"stop: mAnimatorsList is null.");
        }
    }

    public boolean isRunning() {
        return false;
    }

    private void startAnimation() {
        for (Animator animator : this.mAnimatorsList) {
            if (animator.isStarted()) continue;
            animator.start();
        }
    }

    private void stopAnimation() {
        for (Animator animator : this.mAnimatorsList) {
            if (!animator.isStarted()) continue;
            animator.end();
        }
    }

    public static float dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return dpValue * scale + 0.5f;
    }
}

