/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class TrackIndicator
extends IndicatorDrawable {
    private final String TAG = TrackIndicator.class.getSimpleName();
    private final int mCount = 3;
    private float radius = 0.0f;
    private float moveDistance = 0.0f;
    private float[][] translationX_Array = new float[][]{{-0.5f, -1.0f, -0.5f, 0.0f, 0.5f, 1.0f, 0.5f, 0.0f, -0.5f}, {0.0f, 0.5f, 1.0f, 0.5f, 0.0f, -0.5f, -1.0f, -0.5f, 0.0f}, {0.5f, 0.0f, -0.5f, -1.0f, -0.5f, 0.0f, 0.5f, 1.0f, 0.5f}};
    private float[][] scaleXY_Array = new float[][]{{0.5f, 1.0f, 1.5f, 1.0f, 0.5f, 1.0f, 1.5f, 1.0f, 0.5f}, {1.0f, 0.5f, 1.0f, 1.5f, 1.0f, 0.5f, 1.0f, 1.5f, 1.0f}, {1.5f, 1.0f, 0.5f, 1.0f, 1.5f, 1.0f, 0.5f, 1.0f, 1.5f}};
    private float[] translationXValue = new float[]{1.0f, 1.0f, 1.0f};
    private float[] scaleXYValue = new float[]{1.0f, 1.0f, 1.0f};
    private int[] color = new int[]{-65536, -16711936, -16776961};
    private boolean drawAssist = false;

    public TrackIndicator(Context context) {
        Log.d((String)this.TAG, (String)"TrackIndicator: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator translationX = ValueAnimator.ofFloat((float[])this.translationX_Array[i]);
            translationX.setRepeatCount(-1);
            translationX.setDuration(2000L);
            translationX.setInterpolator((TimeInterpolator)new LinearInterpolator());
            ValueAnimator scaleXY = ValueAnimator.ofFloat((float[])this.scaleXY_Array[i]);
            scaleXY.setRepeatCount(-1);
            scaleXY.setDuration(2000L);
            translationX.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translationX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((TrackIndicator)TrackIndicator.this).translationXValue[index] = ((Float)animation.getAnimatedValue()).floatValue();
                }
            });
            scaleXY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((TrackIndicator)TrackIndicator.this).scaleXYValue[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    TrackIndicator.this.invalidateSelf();
                }
            });
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{translationX, scaleXY});
            list.add((Animator)animatorSet);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.moveDistance == 0.0f) {
            this.moveDistance = this.getWidth() / 4;
            this.radius = this.getWidth() / 25;
        }
        this.drawAssist(canvas, paint);
        this.drawBall(canvas, paint);
    }

    private void drawAssist(Canvas canvas, Paint paint) {
        if (this.drawAssist) {
            canvas.drawColor(-65536);
            canvas.drawLine((float)(this.getWidth() / 2), 0.0f, (float)(this.getWidth() / 2), (float)this.getHeight(), paint);
            canvas.drawLine((float)(this.getWidth() / 4), 0.0f, (float)(this.getWidth() / 4), (float)this.getHeight(), paint);
            canvas.drawLine((float)(this.getWidth() / 4 * 3), 0.0f, (float)(this.getWidth() / 4 * 3), (float)this.getHeight(), paint);
        }
    }

    private void drawBall(Canvas canvas, Paint paint) {
        for (int i = 0; i < 3; ++i) {
            float x = (float)(this.getWidth() / 2) + this.translationXValue[i] * this.moveDistance;
            canvas.drawCircle(x, (float)(this.getHeight() / 2), this.scaleXYValue[i] * this.radius, paint);
        }
    }
}

