/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Rect;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class ParallelogramIndicator
extends IndicatorDrawable {
    private final String TAG = ParallelogramIndicator.class.getSimpleName();
    private Path path = new Path();
    private final int mCount = 3;
    private float space;
    private float leftPadding;
    private float offsetWidth;
    private float paraWidth;
    private float paraHeight;
    private boolean drawAssist = false;
    private float[] mAnimatedValue = new float[]{1.0f, 1.0f, 1.0f};

    public ParallelogramIndicator(Context context) {
        Log.d((String)this.TAG, (String)"ParallelogramIndicator: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
        this.mPaint.setAntiAlias(true);
        this.space = ParallelogramIndicator.dip2px(context, 5.0f);
    }

    @Override
    protected ArrayList<ValueAnimator> getAnimation() {
        int[] delay = new int[]{100, 200, 300};
        ArrayList<ValueAnimator> list = new ArrayList<ValueAnimator>();
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((ParallelogramIndicator)ParallelogramIndicator.this).mAnimatedValue[index] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    ParallelogramIndicator.this.invalidateSelf();
                }
            });
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setDuration(1000L);
            valueAnimator.setStartDelay((long)delay[i]);
            list.add(valueAnimator);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.leftPadding == 0.0f) {
            this.paraWidth = this.getWidth() / 20;
            this.paraHeight = this.getHeight() / 12;
            this.offsetWidth = this.paraWidth / 2.0f;
            this.leftPadding = ((float)this.getWidth() - ((this.paraWidth + this.offsetWidth) * 3.0f + this.space * 2.0f)) / 2.0f;
        }
        this.drawAssist(canvas, paint);
        this.drawParallelogram(canvas, paint);
    }

    private void drawAssist(Canvas canvas, Paint paint) {
        if (this.drawAssist) {
            canvas.drawColor(-7829368);
            canvas.drawLine(0.0f, (float)(this.getHeight() / 2), (float)this.getWidth(), (float)(this.getHeight() / 2), paint);
            canvas.drawLine((float)(this.getWidth() / 2), 0.0f, (float)(this.getWidth() / 2), (float)this.getHeight(), paint);
        }
    }

    private void drawParallelogram(Canvas canvas, Paint paint) {
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float x1 = this.leftPadding + this.offsetWidth * (float)(i + 1) + (this.paraWidth + this.space) * (float)i;
            float y1 = (float)(this.getHeight() / 2) - this.paraHeight / 2.0f;
            float x2 = x1 + this.paraWidth;
            float y2 = y1 + this.paraHeight;
            float centerX = (x1 + x2) / 2.0f;
            float centerY = (y1 + y2) / 2.0f;
            canvas.translate(centerX, centerY);
            canvas.scale(this.mAnimatedValue[i], this.mAnimatedValue[i]);
            this.path.reset();
            this.path.moveTo(-(centerX - x1), -this.paraHeight / 2.0f);
            this.path.lineTo(-(centerX - x1) - this.offsetWidth, this.paraHeight / 2.0f);
            this.path.lineTo(-(centerX - x1) - this.offsetWidth + this.paraWidth, this.paraHeight / 2.0f);
            this.path.lineTo(-(centerX - x1) + this.paraWidth, -this.paraHeight / 2.0f);
            this.path.close();
            canvas.drawPath(this.path, paint);
            canvas.restore();
        }
    }
}

