/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Rect;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class ChartRectIndicator2
extends IndicatorDrawable {
    private final String TAG = ChartRectIndicator2.class.getSimpleName();
    private final int mCount = 5;
    private float rectMax;
    private int mCurrAnimatorState = 0;
    private float mAnimatedValue;
    private RectF rectF = new RectF();
    boolean repeatRunned = false;

    public ChartRectIndicator2(Context context) {
        Log.d((String)this.TAG, (String)"ChartRectIndicator2: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
        this.rectMax = ChartRectIndicator2.dip2px(context, 10.0f);
    }

    @Override
    protected ArrayList<ValueAnimator> getAnimation() {
        ArrayList<ValueAnimator> list = new ArrayList<ValueAnimator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ChartRectIndicator2.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                Log.d((String)ChartRectIndicator2.this.TAG, (String)("onAnimationUpdate: mAnimatedValue=" + ChartRectIndicator2.this.mAnimatedValue));
                ChartRectIndicator2.this.invalidateSelf();
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                Log.d((String)ChartRectIndicator2.this.TAG, (String)"onAnimationStart: ");
            }

            public void onAnimationEnd(Animator animation) {
                Log.d((String)ChartRectIndicator2.this.TAG, (String)"onAnimationEnd: ");
            }

            public void onAnimationCancel(Animator animation) {
                Log.d((String)ChartRectIndicator2.this.TAG, (String)"onAnimationCancel: ");
            }

            public void onAnimationRepeat(Animator animation) {
                Log.d((String)ChartRectIndicator2.this.TAG, (String)"onAnimationRepeat: ");
                ChartRectIndicator2.this.repeatRunned = true;
            }
        });
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration(1000L);
        list.add(valueAnimator);
        return list;
    }

    private void changeState() {
        if (this.repeatRunned && !(this.mAnimatedValue > 0.9f)) {
            this.repeatRunned = false;
            ++this.mCurrAnimatorState;
            Log.d((String)this.TAG, (String)("onAnimationRepeat: mCurrAnimatorState=" + this.mCurrAnimatorState));
            if (this.mCurrAnimatorState > 6) {
                Log.d((String)this.TAG, (String)"onAnimationRepeat: set mCurrAnimatorState to 0");
                this.mCurrAnimatorState = 0;
            }
        }
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        float rectWidth;
        this.changeState();
        float rectSpace = rectWidth = (float)(this.getWidth() / 25);
        float startX = ((float)this.getWidth() - (rectWidth * 5.0f + rectSpace * 4.0f)) / 2.0f;
        float bottomY = (float)this.getHeight() / 1.5f;
        for (int i = 0; i < 5 && i <= this.mCurrAnimatorState; ++i) {
            canvas.save();
            float range = 0.5f - Math.abs(this.mAnimatedValue - 0.5f);
            float offsetHeight = range * this.rectMax;
            int j = i % 3;
            this.rectF.setEmpty();
            if (i == this.mCurrAnimatorState) {
                Log.d((String)this.TAG, (String)("draw: " + i + ", " + this.mAnimatedValue + ", " + (bottomY - (float)(j + 1) * this.rectMax * this.mAnimatedValue)));
                this.rectF.set(startX + (float)i * (rectWidth + rectSpace), bottomY - (float)(j + 1) * this.rectMax * this.mAnimatedValue, startX + (float)i * (rectWidth + rectSpace) + rectWidth, bottomY);
            } else {
                this.rectF.set(startX + (float)i * (rectWidth + rectSpace), bottomY - (float)(j + 1) * this.rectMax - offsetHeight, startX + (float)i * (rectWidth + rectSpace) + rectWidth, bottomY);
            }
            canvas.drawRect(this.rectF, paint);
            canvas.restore();
        }
    }
}

