/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class DropIndicator
extends IndicatorDrawable {
    private final String TAG = DropIndicator.class.getSimpleName();
    private float mAnimatedValue;
    private RectF mRectF = new RectF();
    private boolean drawAssist = false;

    public DropIndicator(Context context) {
        Log.d((String)this.TAG, (String)("DropIndicator: " + this.getWidth()));
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
    }

    @Override
    protected ArrayList<ValueAnimator> getAnimation() {
        ArrayList<ValueAnimator> list = new ArrayList<ValueAnimator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                DropIndicator.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                DropIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration(1500L);
        list.add(valueAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        this.drawAssist(canvas, paint);
        this.drawBall(canvas, paint);
    }

    private void drawAssist(Canvas canvas, Paint paint) {
        if (this.drawAssist) {
            canvas.drawColor(-65536);
            float maxMove = this.getWidth() / 2;
            float x = ((float)this.getWidth() - maxMove) / 2.0f;
            canvas.drawLine(x, 0.0f, x, (float)this.getHeight(), paint);
            canvas.drawLine(x + maxMove / 2.0f, 0.0f, x + maxMove / 2.0f, (float)this.getHeight(), paint);
            canvas.drawLine(x + maxMove, 0.0f, x + maxMove, (float)this.getHeight(), paint);
        }
    }

    private void drawBall(Canvas canvas, Paint paint) {
        float maxMove = this.getWidth() / 2;
        float radius = this.getWidth() / 25;
        float x = ((float)this.getWidth() - maxMove) / 2.0f;
        float y = this.getHeight() / 2;
        float percent = 0.0f;
        if ((double)this.mAnimatedValue <= 0.5) {
            percent = this.mAnimatedValue;
        } else if (this.mAnimatedValue <= 1.0f) {
            percent = 1.0f - this.mAnimatedValue;
        }
        float extra_percent = 0.0f;
        if ((double)this.mAnimatedValue <= 0.25) {
            extra_percent = this.mAnimatedValue;
        } else if (this.mAnimatedValue <= 0.5f) {
            extra_percent = 0.5f - this.mAnimatedValue;
        } else if ((double)this.mAnimatedValue <= 0.75) {
            extra_percent = this.mAnimatedValue - 0.5f;
        } else if ((double)this.mAnimatedValue <= 1.0) {
            extra_percent = 1.0f - this.mAnimatedValue;
        }
        this.mRectF.set(x - radius + maxMove * 2.0f * percent - radius * 4.0f * extra_percent, y - radius, x + radius + maxMove * 2.0f * percent + radius * 4.0f * extra_percent, y + radius);
        canvas.drawOval(this.mRectF, paint);
    }
}

