/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.presentation;

import com.eway.payment.sdk.data.beans.NVPair;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.entities.UserMessageResponse;
import com.eway.payment.sdk.data.net.RapidRestAdapter;
import com.eway.payment.sdk.domain.usecases.AbsAsyncUserMessageUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.AndroidPayUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.AsynUserMessageUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.EncryptValuesUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.SubmitPaymentUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.UserMessageUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.rxEncryptValuesUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.rxSubmitPaymentUseCase;
import com.eway.payment.sdk.domain.usecases.Impl.rxUserMessageUseCase;
import io.reactivex.Flowable;
import java.io.IOException;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Response;

public class RapidAPI {
    public static void setRapidEndpoint(String rapidEndpoint) {
        RapidRestAdapter.RapidEndpoint = rapidEndpoint;
    }

    public static void setPublicAPIKey(String publicAPIKey) {
        RapidRestAdapter.PublicAPIKey = publicAPIKey;
    }

    public static Response<SubmitPayResponse> submitPayment(Transaction transaction) throws IOException {
        SubmitPaymentUseCase submitPaymentUseCase = new SubmitPaymentUseCase(transaction);
        return submitPaymentUseCase.execute();
    }

    public static Call<SubmitPayResponse> asyncSubmitPayment(Transaction transaction) {
        SubmitPaymentUseCase submitPaymentUseCase = new SubmitPaymentUseCase(transaction);
        return submitPaymentUseCase.asyncExecute();
    }

    public static Flowable<SubmitPayResponse> rxSubmitPayment(Transaction transaction) {
        rxSubmitPaymentUseCase rxSubmitPayUseCase = new rxSubmitPaymentUseCase(transaction);
        return rxSubmitPayUseCase.rxExecute();
    }

    public static Response<EncryptItemsResponse> encryptValues(ArrayList<NVPair> values) throws IOException {
        EncryptValuesUseCase encryptValuesUseCase = new EncryptValuesUseCase();
        EncryptValuesUseCase.setValues(values);
        return encryptValuesUseCase.execute();
    }

    public static Call<EncryptItemsResponse> asyncEncryptValues(ArrayList<NVPair> values) throws IOException {
        EncryptValuesUseCase encryptValuesUseCase = new EncryptValuesUseCase();
        EncryptValuesUseCase.setValues(values);
        return encryptValuesUseCase.asyncExecute();
    }

    public static Flowable<EncryptItemsResponse> rxEncryptValues(ArrayList<NVPair> values) {
        rxEncryptValuesUseCase encryptValuesUseCase = new rxEncryptValuesUseCase();
        rxEncryptValuesUseCase.setValues(values);
        return encryptValuesUseCase.rxExecute();
    }

    public static UserMessageResponse userMessage(String language, String errorCodes) {
        UserMessageUseCase userMessageUseCase = new UserMessageUseCase(language, errorCodes);
        return userMessageUseCase.execute();
    }

    public static AbsAsyncUserMessageUseCase.CallbackUserMessage asynUserMessage(String Language, String ErrorCodes, AbsAsyncUserMessageUseCase.CallbackUserMessage callbackUserMessage) {
        AsynUserMessageUseCase asynUserMessageUseCase = new AsynUserMessageUseCase(Language, ErrorCodes, callbackUserMessage);
        asynUserMessageUseCase.asyncExecute();
        return callbackUserMessage;
    }

    public static Flowable<UserMessageResponse> rxUserMessage(String language, String ErrorCodes) {
        rxUserMessageUseCase rxuserMessageUseCase = new rxUserMessageUseCase(language, ErrorCodes);
        return rxuserMessageUseCase.rxExecute();
    }

    public static Response<SubmitPayResponse> synAndroidPay(Transaction transaction) throws IOException {
        AndroidPayUseCase androidPayUseCase = new AndroidPayUseCase(transaction);
        return androidPayUseCase.execute();
    }
}

