/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.domain.usecases.Impl;

import com.eway.payment.sdk.data.beans.CodeDetail;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.UserMessageResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.data.util.RequestBuilder;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.AbsAsyncUserMessageUseCase;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AsynUserMessageUseCase
extends AbsAsyncUserMessageUseCase {
    private String language;
    private RapidRepository rapidRepository;
    private String ErrorCodes;
    private CodeLookupResponse codeLookupResponse;
    AbsAsyncUserMessageUseCase.CallbackUserMessage callbackUserMessage;

    public AsynUserMessageUseCase(String language, String ErrorCodes, AbsAsyncUserMessageUseCase.CallbackUserMessage callbackUserMessage) {
        this.language = language;
        this.ErrorCodes = ErrorCodes;
        this.rapidRepository = new RapidDataRepository(new RapidDataFactory());
        this.callbackUserMessage = callbackUserMessage;
    }

    @Override
    protected AbsAsyncUserMessageUseCase.CallbackUserMessage buildUseCase() {
        this.rapidRepository.userMessage(RequestBuilder.buildCodeLookUpRequest(this.language, this.ErrorCodes)).enqueue((Callback)new Callback<CodeLookupResponse>(){

            public void onResponse(Call<CodeLookupResponse> call, Response<CodeLookupResponse> response) {
                AsynUserMessageUseCase.this.codeLookupResponse = new CodeLookupResponse();
                AsynUserMessageUseCase.this.codeLookupResponse = (CodeLookupResponse)response.body();
                if (response.isSuccessful()) {
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    for (CodeDetail codeDetail : AsynUserMessageUseCase.this.codeLookupResponse.getCodeDetails()) {
                        errorMessages.add(codeDetail.getDisplayMessage());
                    }
                    AsynUserMessageUseCase.this.callbackUserMessage.onSuccess(new UserMessageResponse(errorMessages, null));
                } else {
                    AsynUserMessageUseCase.this.callbackUserMessage.onError(new Throwable(response.message()));
                }
            }

            public void onFailure(Call<CodeLookupResponse> call, Throwable t) {
                AsynUserMessageUseCase.this.callbackUserMessage.onError(t);
            }
        });
        return this.callbackUserMessage;
    }
}

