/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.domain.executor;

import com.eway.payment.sdk.domain.executor.ThreadExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

@Singleton
public class JobExecutor
implements ThreadExecutor {
    private final int INITIAL_POOL_SIZE = 3;
    private final int MAX_POOL_SIZE = 5;
    private final int KEEP_ALIVE_TIME = 10;
    private final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
    private final ThreadPoolExecutor threadPoolExecutor;
    private final ThreadFactory threadFactory = new JobThreadFactory();

    public JobExecutor() {
        this.threadPoolExecutor = new ThreadPoolExecutor(3, 5, 10L, this.KEEP_ALIVE_TIME_UNIT, this.workQueue, this.threadFactory);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable to execute cannot be null");
        }
        this.threadPoolExecutor.execute(runnable);
    }

    private class JobThreadFactory
    implements ThreadFactory {
        int counter = 0;
        private final String THREAD_NAME = "android_";

        private JobThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "android_" + String.valueOf(this.counter++));
        }
    }
}

