/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.data.util;

import android.util.Log;
import com.eway.payment.sdk.data.beans.AndroidPayID;
import com.eway.payment.sdk.data.beans.NVPair;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.beans.Utils;
import com.eway.payment.sdk.data.entities.CodeLookupRequest;
import com.eway.payment.sdk.data.entities.EncryptValuesRequest;
import com.eway.payment.sdk.data.entities.SubmitPaymentRequest;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;

public class RequestBuilder {
    public static Boolean isDeviceIdTesting = false;
    private static final String PROCESSPAYMENT = "ProcessPayment";
    private static final String ECRYPT = "eCrypt";

    public static SubmitPaymentRequest buildSubmitRequest(Transaction transaction) {
        SubmitPaymentRequest request = new SubmitPaymentRequest();
        request.setMethod(PROCESSPAYMENT);
        request.setCustomer(Utils.transformCustomer(transaction.getCustomer()));
        request.setShippingAddress(Utils.transformShippingAddress(transaction.getShippingDetails()));
        request.setShippingMethod(Utils.nullSafeGetShippingMethod(transaction));
        request.setItems(transaction.getLineItems());
        request.setOptions(Utils.transformOptions(transaction.getOptions()));
        request.setPayment(transaction.getPayment());
        request.setDeviceID(RequestBuilder.isDeviceIDForTesting(isDeviceIdTesting));
        request.setPartnerID(transaction.getPartnerID());
        request.setTransactionType(Utils.nullSafeGetTransactionType(transaction));
        return request;
    }

    public static EncryptValuesRequest buildEncryptValues(ArrayList<NVPair> Values) {
        EncryptValuesRequest request = new EncryptValuesRequest();
        request.setMethod(ECRYPT);
        request.setItems(Values);
        return request;
    }

    public static CodeLookupRequest buildCodeLookUpRequest(String language, String ErrorCodes) {
        return new CodeLookupRequest(RequestBuilder.nullSafeGetLocale(language), RequestBuilder.parseErrorCodeList(ErrorCodes));
    }

    public static SubmitPaymentRequest buildAndroidPaySubmitRequest(Transaction transaction) {
        SubmitPaymentRequest request = new SubmitPaymentRequest();
        request.setMethod(PROCESSPAYMENT);
        request.setCustomer(Utils.transformCustomer(transaction.getCustomer()));
        request.setShippingAddress(transaction.getShippingAddress());
        request.setShippingMethod(Utils.nullSafeGetShippingMethod(transaction));
        request.setItems(transaction.getLineItems());
        request.setPayment(transaction.getPayment());
        request.setSecuredCardData(RequestBuilder.putHeaderToAndroidPay(transaction.getAndroidPay()));
        request.setDeviceID(RequestBuilder.isDeviceIDForTesting(isDeviceIdTesting));
        request.setCustomerIP("");
        request.setTransactionType(Utils.nullSafeGetTransactionType(transaction));
        return request;
    }

    private static String nullSafeGetLocale(String Language) {
        return Language != null ? Language : Locale.getDefault().toString();
    }

    private static ArrayList<String> parseErrorCodeList(String ErrorCodes) {
        return ErrorCodes != null ? Utils.newArrayList(ErrorCodes.trim().replaceAll("\\s+", "").split(",")) : Utils.newArrayList(new String[0]);
    }

    private static String putHeaderToAndroidPay(String jsonFormatted) {
        Moshi moshi = new Moshi.Builder().build();
        AndroidPayID androidPayID = null;
        JsonAdapter adapter = moshi.adapter(AndroidPayID.class);
        try {
            androidPayID = (AndroidPayID)adapter.lenient().fromJson(jsonFormatted);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        jsonFormatted = adapter.toJson((Object)androidPayID);
        Log.d((String)"SecuredData", (String)("AndroidPayID:" + jsonFormatted));
        return "AndroidPayID:" + jsonFormatted;
    }

    private static String isDeviceIDForTesting(Boolean isDeviceIDForTesting) {
        String deviceId = isDeviceIDForTesting != false ? UUID.randomUUID().toString() : Utils.getUniquePsuedoID();
        return deviceId;
    }
}

