/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.data.repository.sourcedata;

import com.eway.payment.sdk.data.entities.CodeLookupRequest;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.entities.EncryptValuesRequest;
import com.eway.payment.sdk.data.entities.RapidConfigurationException;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.entities.SubmitPaymentRequest;
import com.eway.payment.sdk.data.net.RapidRestAdapter;
import com.eway.payment.sdk.data.repository.sourcedata.RapidNetData;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import retrofit2.Call;

public class RapidNetRepository
implements RapidNetData {
    @Override
    public Flowable<SubmitPayResponse> rxSubmitPayment(SubmitPaymentRequest request) {
        try {
            return RapidRestAdapter.rxCallPost().rxObsSubmitPayment(request).toFlowable(BackpressureStrategy.BUFFER);
        }
        catch (RapidConfigurationException e) {
            return this.exceptionError(e);
        }
        catch (KeyManagementException e) {
            return this.exceptionError(e);
        }
        catch (NoSuchAlgorithmException e) {
            return this.exceptionError(e);
        }
    }

    @Override
    public Call<SubmitPayResponse> SubmitResponse(SubmitPaymentRequest request) {
        try {
            return RapidRestAdapter.callPost().submitPayment(request);
        }
        catch (RapidConfigurationException e) {
            SubmitPayResponse response = null;
            try {
                response = new SubmitPayResponse(e.getErrorCodes(), "", "");
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
            }
            try {
                throw new RapidConfigurationException(new String[]{response.getErrors()});
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        catch (KeyManagementException e) {
            SubmitPayResponse response = new SubmitPayResponse(e.getMessage(), "", "");
            try {
                throw new RapidConfigurationException(new String[]{response.getErrors()});
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        catch (NoSuchAlgorithmException e) {
            SubmitPayResponse response = new SubmitPayResponse(e.getMessage(), "", "");
            try {
                throw new RapidConfigurationException(new String[]{response.getErrors()});
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    @Override
    public Flowable<EncryptItemsResponse> rxEncryptValues(EncryptValuesRequest request) {
        try {
            return RapidRestAdapter.rxCallPost().rxObsEncryptValues(request).toFlowable(BackpressureStrategy.BUFFER);
        }
        catch (RapidConfigurationException e) {
            return this.exceptionError(e);
        }
        catch (KeyManagementException e) {
            return this.exceptionError(e);
        }
        catch (NoSuchAlgorithmException e) {
            return this.exceptionError(e);
        }
    }

    @Override
    public Call<EncryptItemsResponse> EncryptValues(EncryptValuesRequest request) {
        try {
            return RapidRestAdapter.callPost().encryptValues(request);
        }
        catch (RapidConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Flowable<CodeLookupResponse> rxUserMessage(CodeLookupRequest request) {
        try {
            return RapidRestAdapter.rxCallPost().rxCodeLookUp(request).toFlowable(BackpressureStrategy.BUFFER);
        }
        catch (RapidConfigurationException e) {
            return this.exceptionError(e);
        }
        catch (KeyManagementException e) {
            return this.exceptionError(e);
        }
        catch (NoSuchAlgorithmException e) {
            return this.exceptionError(e);
        }
    }

    @Override
    public Call<CodeLookupResponse> UserMessage(CodeLookupRequest request) {
        try {
            return RapidRestAdapter.callPost().codeLookUp(request);
        }
        catch (RapidConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Call<SubmitPayResponse> androidPay(SubmitPaymentRequest request) {
        try {
            return RapidRestAdapter.callPost().androidPaySubmitPayment(request);
        }
        catch (RapidConfigurationException e) {
            SubmitPayResponse response = null;
            try {
                response = new SubmitPayResponse(e.getErrorCodes(), "", "");
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
            }
            try {
                throw new RapidConfigurationException(new String[]{response.getErrors()});
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        catch (KeyManagementException e) {
            SubmitPayResponse response = new SubmitPayResponse(e.getMessage(), "", "");
            try {
                throw new RapidConfigurationException(new String[]{response.getErrors()});
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        catch (NoSuchAlgorithmException e) {
            SubmitPayResponse response = new SubmitPayResponse(e.getMessage(), "", "");
            try {
                throw new RapidConfigurationException(new String[]{response.getErrors()});
            }
            catch (RapidConfigurationException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    private <T> Flowable<T> exceptionError(final Exception exception) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(){

            public void subscribe(FlowableEmitter<T> e) throws Exception {
                e.onError((Throwable)exception);
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR);
    }
}

