/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.android;

import com.eway.payment.sdk.android.RapidConfigurationException;
import com.eway.payment.sdk.android.Utils;
import com.eway.payment.sdk.android.beans.CodeDetail;
import com.eway.payment.sdk.android.beans.NVPair;
import com.eway.payment.sdk.android.beans.Transaction;
import com.eway.payment.sdk.android.entities.CodeLookupRequest;
import com.eway.payment.sdk.android.entities.CodeLookupResponse;
import com.eway.payment.sdk.android.entities.EncryptItemsResponse;
import com.eway.payment.sdk.android.entities.EncryptValuesRequest;
import com.eway.payment.sdk.android.entities.SubmitPayResponse;
import com.eway.payment.sdk.android.entities.SubmitPaymentRequest;
import com.eway.payment.sdk.android.entities.UserMessageResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class RapidAPI {
    private static final String PRODUCTION = "Production";
    private static final String PRODUCTION_URL = "https://api.ewaypayments.com";
    private static final String SANDBOX = "Sandbox";
    private static final String SANDBOX_URL = "https://api.sandbox.ewaypayments.com";
    private static final String PROCESSPAYMENT = "ProcessPayment";
    private static final String PAYMENT = "payment";
    private static final String ECRYPT = "eCrypt";
    private static final String ENCRYPT = "encrypt";
    private static final String CODELOOKUP = "CodeLookup";
    private static final String VERSIONREPORTED = "1.2";
    public static String RapidEndpoint;
    public static String PublicAPIKey;

    private RapidAPI() {
    }

    public static SubmitPayResponse submitPayment(Transaction transaction) throws IOException, RapidConfigurationException {
        try {
            RapidAPI.errorCheck();
            if (transaction == null) {
                return new SubmitPayResponse("S9995", "", "");
            }
            SubmitPaymentRequest request = RapidAPI.buildSubmitRequest(transaction);
            Call<SubmitPayResponse> call = RapidAPI.callPost().submitPayment(request);
            retrofit2.Response submitPayResponse = call.execute();
            if (submitPayResponse.errorBody() != null) {
                RapidAPI.errorList(submitPayResponse.code());
            }
            return (SubmitPayResponse)submitPayResponse.body();
        }
        catch (RapidConfigurationException e) {
            SubmitPayResponse response = new SubmitPayResponse(e.getErrorCodes(), "", "");
            throw new RapidConfigurationException(new String[]{response.getErrors()});
        }
    }

    public static void asycSubmitPayment(Transaction transaction, final RapidRecordingTransactionListener callback) {
        try {
            RapidAPI.errorCheck();
            if (transaction == null) {
                throw new RapidConfigurationException(new String[]{"S9995"});
            }
            SubmitPaymentRequest request = RapidAPI.buildSubmitRequest(transaction);
            RapidAPI.callPost().submitPayment(request).enqueue((Callback)new Callback<SubmitPayResponse>(){

                public void onResponse(Call<SubmitPayResponse> call, retrofit2.Response<SubmitPayResponse> response) {
                    if (response.isSuccess()) {
                        if (((SubmitPayResponse)response.body()).getErrors() == null) {
                            callback.onResponseReceivedSuccess((SubmitPayResponse)response.body());
                        } else {
                            callback.onResponseReceivedError(((SubmitPayResponse)response.body()).getErrors());
                        }
                    } else {
                        try {
                            RapidAPI.errorList(response.code());
                        }
                        catch (RapidConfigurationException e) {
                            try {
                                callback.onResponseReceivedException(new SubmitPayResponse(e.getErrorCodes(), null, null));
                            }
                            catch (RapidConfigurationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }

                public void onFailure(Call<SubmitPayResponse> call, Throwable t) {
                    callback.onResponseReceivedFailure(t.getMessage());
                }
            });
        }
        catch (RapidConfigurationException ex) {
            try {
                callback.onResponseReceivedException(new SubmitPayResponse(ex.getErrorCodes(), null, null));
            }
            catch (RapidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public static Observable<SubmitPayResponse> rxSubmitPayment(Transaction transaction) {
        try {
            RapidAPI.errorCheck();
            if (transaction == null) {
                throw new RapidConfigurationException(new String[]{"S9995"});
            }
            SubmitPaymentRequest request = RapidAPI.buildSubmitRequest(transaction);
            return RapidAPI.rxCallPost().rxObsSubmitPayment(request).observeOn(Schedulers.io()).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends SubmitPayResponse>>(){

                public Observable<? extends SubmitPayResponse> call(Throwable throwable) {
                    try {
                        RapidAPI.errorCheck();
                        if (throwable.getMessage().contains("401")) {
                            throw new RapidConfigurationException(new String[]{"S9993"});
                        }
                        if (throwable.getMessage().contains("443")) {
                            throw new RapidConfigurationException(new String[]{"S9991"});
                        }
                        throw new RapidConfigurationException(new String[]{"S9992"});
                    }
                    catch (RapidConfigurationException e) {
                        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<SubmitPayResponse>(){

                            public void call(Subscriber<? super SubmitPayResponse> subscriber) {
                                try {
                                    subscriber.onError(new Throwable(e.getErrorCodes()));
                                }
                                catch (RapidConfigurationException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<SubmitPayResponse, Observable<SubmitPayResponse>>(){

                public Observable<SubmitPayResponse> call(final SubmitPayResponse submitPayResponse) {
                    return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<SubmitPayResponse>(){

                        public void call(Subscriber<? super SubmitPayResponse> subscriber) {
                            subscriber.onCompleted();
                            subscriber.onNext((Object)submitPayResponse);
                        }
                    });
                }
            });
        }
        catch (RapidConfigurationException e) {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<SubmitPayResponse>(){

                public void call(Subscriber<? super SubmitPayResponse> subscriber) {
                    try {
                        subscriber.onError(new Throwable(e.getErrorCodes()));
                    }
                    catch (RapidConfigurationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
    }

    public static EncryptItemsResponse encryptValues(ArrayList<NVPair> Values) throws IOException, RapidConfigurationException {
        try {
            RapidAPI.errorCheck();
            EncryptValuesRequest request = RapidAPI.buildEncryptValues(Values);
            Call<EncryptItemsResponse> call = RapidAPI.callPost().encryptValues(request);
            retrofit2.Response encryptValuesRequestResponse = call.execute();
            if (encryptValuesRequestResponse.errorBody() != null) {
                RapidAPI.errorList(encryptValuesRequestResponse.raw().code());
            }
            return (EncryptItemsResponse)encryptValuesRequestResponse.body();
        }
        catch (RapidConfigurationException e) {
            return new EncryptItemsResponse(e.getErrorCodes(), null, String.valueOf(0));
        }
    }

    public static void asycEncryptValues(ArrayList<NVPair> Values, final RapidEncryptValuesListener callback) {
        try {
            RapidAPI.errorCheck();
            EncryptValuesRequest request = RapidAPI.buildEncryptValues(Values);
            RapidAPI.callPost().encryptValues(request).enqueue((Callback)new Callback<EncryptItemsResponse>(){

                public void onResponse(Call<EncryptItemsResponse> call, retrofit2.Response<EncryptItemsResponse> response) {
                    if (response.isSuccess()) {
                        if (((EncryptItemsResponse)response.body()).getErrors() == null) {
                            callback.onResponseReceivedSuccess((EncryptItemsResponse)response.body());
                        } else {
                            callback.onResponseReceivedError(((EncryptItemsResponse)response.body()).getErrors());
                        }
                    } else {
                        try {
                            RapidAPI.errorList(response.code());
                        }
                        catch (RapidConfigurationException e) {
                            try {
                                callback.onResponseReceivedException(new EncryptItemsResponse(e.getErrorCodes(), null, String.valueOf(0)));
                            }
                            catch (RapidConfigurationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }

                public void onFailure(Call<EncryptItemsResponse> call, Throwable t) {
                    callback.onResponseReceivedFailure(t.getMessage());
                }
            });
        }
        catch (RapidConfigurationException ex) {
            try {
                callback.onResponseReceivedException(new EncryptItemsResponse(ex.getErrorCodes(), null, String.valueOf(0)));
            }
            catch (RapidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public static Observable<EncryptItemsResponse> rxEncryptValues(ArrayList<NVPair> Values) {
        try {
            RapidAPI.errorCheck();
            EncryptValuesRequest request = RapidAPI.buildEncryptValues(Values);
            return RapidAPI.rxCallPost().rxObsEncryptValues(request).observeOn(Schedulers.io()).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends EncryptItemsResponse>>(){

                public Observable<? extends EncryptItemsResponse> call(Throwable throwable) {
                    try {
                        if (throwable.getMessage().contains("401")) {
                            throw new RapidConfigurationException(new String[]{"S9993"});
                        }
                        if (throwable.getMessage().contains("443")) {
                            throw new RapidConfigurationException(new String[]{"S9991"});
                        }
                        throw new RapidConfigurationException(new String[]{"S9992"});
                    }
                    catch (RapidConfigurationException e) {
                        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<EncryptItemsResponse>(){

                            public void call(Subscriber<? super EncryptItemsResponse> subscriber) {
                                try {
                                    subscriber.onError(new Throwable(e.getErrorCodes()));
                                }
                                catch (RapidConfigurationException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<EncryptItemsResponse, Observable<EncryptItemsResponse>>(){

                public Observable<EncryptItemsResponse> call(final EncryptItemsResponse encryptItemsResponse) {
                    return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<EncryptItemsResponse>(){

                        public void call(Subscriber<? super EncryptItemsResponse> subscriber) {
                            subscriber.onCompleted();
                            subscriber.onNext((Object)encryptItemsResponse);
                        }
                    });
                }
            });
        }
        catch (RapidConfigurationException e) {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<EncryptItemsResponse>(){

                public void call(Subscriber<? super EncryptItemsResponse> subscriber) {
                    try {
                        subscriber.onError(new Throwable(e.getErrorCodes()));
                    }
                    catch (RapidConfigurationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
    }

    public static UserMessageResponse userMessage(String Language, String ErrorCodes) throws IOException, RapidConfigurationException {
        try {
            Call<CodeLookupResponse> call = RapidAPI.callPost().codeLookUp(new CodeLookupRequest(RapidAPI.nullSafeGetLocale(Language), RapidAPI.parseErrorCodeList(ErrorCodes)));
            retrofit2.Response codeLookupResponse = call.execute();
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (CodeDetail codeDetail : ((CodeLookupResponse)codeLookupResponse.body()).getCodeDetails()) {
                errorMessages.add(codeDetail.getDisplayMessage());
            }
            return new UserMessageResponse(errorMessages, null);
        }
        catch (RapidConfigurationException e) {
            return new UserMessageResponse(null, e.getErrorCodes());
        }
    }

    public static void asycUserMessage(String Language, String ErrorCodes, final RapidUserMessageListener callback) throws RapidConfigurationException {
        RapidAPI.callPost().codeLookUp(new CodeLookupRequest(RapidAPI.nullSafeGetLocale(Language), RapidAPI.parseErrorCodeList(ErrorCodes))).enqueue((Callback)new Callback<CodeLookupResponse>(){

            public void onResponse(Call<CodeLookupResponse> call, retrofit2.Response<CodeLookupResponse> response) {
                if (response.isSuccess()) {
                    if (((CodeLookupResponse)response.body()).getErrors() == null) {
                        ArrayList<String> errorMessages = new ArrayList<String>();
                        for (CodeDetail codeDetail : ((CodeLookupResponse)response.body()).getCodeDetails()) {
                            errorMessages.add(codeDetail.getDisplayMessage());
                        }
                        callback.onResponseReceivedSuccess(new UserMessageResponse(errorMessages, null));
                    } else {
                        callback.onResponseReceivedError(((CodeLookupResponse)response.body()).getErrors());
                    }
                } else {
                    try {
                        RapidAPI.errorList(response.code());
                    }
                    catch (RapidConfigurationException e) {
                        try {
                            callback.onResponseReceivedException(new UserMessageResponse(null, e.getErrorCodes()));
                        }
                        catch (RapidConfigurationException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }

            public void onFailure(Call<CodeLookupResponse> call, Throwable t) {
                callback.onResponseReceivedFailure(t.getMessage());
            }
        });
    }

    public static Observable<UserMessageResponse> rxUserMessage(String Language, String ErrorCodes) {
        try {
            RapidAPI.errorCheck();
            return RapidAPI.rxCallPost().rxCodeLookUp(new CodeLookupRequest(RapidAPI.nullSafeGetLocale(Language), RapidAPI.parseErrorCodeList(ErrorCodes))).observeOn(Schedulers.io()).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends CodeLookupResponse>>(){

                public Observable<? extends CodeLookupResponse> call(Throwable throwable) {
                    try {
                        if (throwable.getMessage().contains("401")) {
                            throw new RapidConfigurationException(new String[]{"S9993"});
                        }
                        if (throwable.getMessage().contains("443")) {
                            throw new RapidConfigurationException(new String[]{"S9991"});
                        }
                        throw new RapidConfigurationException(new String[]{"S9992"});
                    }
                    catch (RapidConfigurationException e) {
                        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<CodeLookupResponse>(){

                            public void call(Subscriber<? super CodeLookupResponse> subscriber) {
                                try {
                                    subscriber.onError(new Throwable(e.getErrorCodes()));
                                }
                                catch (RapidConfigurationException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<CodeLookupResponse, Observable<UserMessageResponse>>(){

                public Observable<UserMessageResponse> call(final CodeLookupResponse codeLookupResponse) {
                    return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<UserMessageResponse>(){

                        public void call(Subscriber<? super UserMessageResponse> subscriber) {
                            ArrayList<String> errorMessages = new ArrayList<String>();
                            for (CodeDetail codeDetail : codeLookupResponse.getCodeDetails()) {
                                errorMessages.add(codeDetail.getDisplayMessage());
                            }
                            subscriber.onNext((Object)new UserMessageResponse(errorMessages, null));
                            subscriber.onCompleted();
                        }
                    });
                }
            });
        }
        catch (RapidConfigurationException e) {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<UserMessageResponse>(){

                public void call(Subscriber<? super UserMessageResponse> subscriber) {
                    subscriber.onError(new Throwable(e.getMessage()));
                }
            });
        }
    }

    private static ArrayList<String> parseErrorCodeList(String ErrorCodes) {
        return ErrorCodes != null ? Utils.newArrayList(ErrorCodes.trim().replaceAll("\\s+", "").split(",")) : Utils.newArrayList(new String[0]);
    }

    private static String nullSafeGetLocale(String Language) {
        return Language != null ? Language : Locale.getDefault().toString();
    }

    protected static rapidAndroidApi callPost() throws RapidConfigurationException {
        String baseUrl = RapidAPI.changeUrl(RapidEndpoint);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(RapidAPI.getEwayClient()).build();
        rapidAndroidApi adapter = (rapidAndroidApi)retrofit.create(rapidAndroidApi.class);
        return adapter;
    }

    protected static rapidAndroidApi rxCallPost() throws RapidConfigurationException {
        String baseUrl = RapidAPI.changeUrl(RapidEndpoint);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).client(RapidAPI.getEwayClient()).build();
        rapidAndroidApi adapter = (rapidAndroidApi)retrofit.create(rapidAndroidApi.class);
        return adapter;
    }

    public static SubmitPaymentRequest buildSubmitRequest(Transaction transaction) {
        SubmitPaymentRequest request = new SubmitPaymentRequest();
        request.setMethod(PROCESSPAYMENT);
        request.setCustomer(Utils.transformCustomer(transaction.getCustomer()));
        request.setShippingAddress(Utils.transformShippingAddress(transaction.getShippingDetails()));
        request.setShippingMethod(Utils.nullSafeGetShippingMethod(transaction));
        request.setItems(transaction.getLineItems());
        request.setOptions(Utils.transformOptions(transaction.getOptions()));
        request.setPayment(transaction.getPayment());
        request.setDeviceID(Utils.getUniquePsuedoID());
        request.setPartnerID(transaction.getPartnerID());
        request.setTransactionType(Utils.nullSafeGetTransactionType(transaction));
        return request;
    }

    public static EncryptValuesRequest buildEncryptValues(ArrayList<NVPair> Values) {
        EncryptValuesRequest request = new EncryptValuesRequest();
        request.setMethod(ECRYPT);
        request.setItems(Values);
        return request;
    }

    private static OkHttpClient getEwayClient() throws RapidConfigurationException {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                String credential = Credentials.basic((String)PublicAPIKey, (String)"");
                Request.Builder requestBuilder = originalRequest.newBuilder().header("Authorization", credential).header("User-Agent", ";eWAY SDK Android 1.2").method(originalRequest.method(), originalRequest.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        }).connectTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
        return okHttpClient;
    }

    private static void errorList(int responseCode) throws RapidConfigurationException {
        if (responseCode == 401) {
            throw new RapidConfigurationException(new String[]{"S9993"});
        }
        if (responseCode == 443) {
            throw new RapidConfigurationException(new String[]{"S9991"});
        }
        throw new RapidConfigurationException(new String[]{"S9992"});
    }

    private static void errorCheck() throws RapidConfigurationException {
        if (PublicAPIKey == null || PublicAPIKey.isEmpty()) {
            throw new RapidConfigurationException(new String[]{"S9991"});
        }
        if (RapidEndpoint == null || RapidEndpoint.isEmpty()) {
            throw new RapidConfigurationException(new String[]{"S9990"});
        }
        String urlPattern = "^http(s{0,1})://[a-zA-Z0-9_/\\-\\.]+\\.([A-Za-z/]{2,5})[a-zA-Z0-9_/\\&\\?\\=\\-\\.\\~\\%]*";
        if (!RapidEndpoint.matches(urlPattern)) {
            throw new RapidConfigurationException(new String[]{"S9992"});
        }
    }

    public static String changeUrl(String url) throws RapidConfigurationException {
        RapidAPI.errorCheck();
        String baseUrl = url;
        if (PRODUCTION.equalsIgnoreCase(baseUrl)) {
            baseUrl = PRODUCTION_URL;
        } else if (SANDBOX.equalsIgnoreCase(baseUrl)) {
            baseUrl = SANDBOX_URL;
        }
        return baseUrl;
    }

    public static interface RapidUserMessageListener {
        public void onResponseReceivedSuccess(UserMessageResponse var1);

        public void onResponseReceivedError(String var1);

        public void onResponseReceivedFailure(String var1);

        public void onResponseReceivedException(UserMessageResponse var1);
    }

    public static interface RapidEncryptValuesListener {
        public void onResponseReceivedSuccess(EncryptItemsResponse var1);

        public void onResponseReceivedError(String var1);

        public void onResponseReceivedFailure(String var1);

        public void onResponseReceivedException(EncryptItemsResponse var1);
    }

    public static interface RapidRecordingTransactionListener {
        public void onResponseReceivedSuccess(SubmitPayResponse var1);

        public void onResponseReceivedError(String var1);

        public void onResponseReceivedFailure(String var1);

        public void onResponseReceivedException(SubmitPayResponse var1);
    }

    public static interface rapidAndroidApi {
        @Headers(value={"Content-Type: application/json"})
        @POST(value="/payment")
        public Call<SubmitPayResponse> submitPayment(@Body SubmitPaymentRequest var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="/payment")
        public Observable<SubmitPayResponse> rxObsSubmitPayment(@Body SubmitPaymentRequest var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="/encrypt")
        public Call<EncryptItemsResponse> encryptValues(@Body EncryptValuesRequest var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="/encrypt")
        public Observable<EncryptItemsResponse> rxObsEncryptValues(@Body EncryptValuesRequest var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="/codelookup")
        public Call<CodeLookupResponse> codeLookUp(@Body CodeLookupRequest var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="/codelookup")
        public Observable<CodeLookupResponse> rxCodeLookUp(@Body CodeLookupRequest var1);
    }
}

