/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.state;

import android.app.Application;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evernote.android.state.AndroidLifecycleCallbacks;
import com.evernote.android.state.Injector;
import java.util.Map;

final class StateSaverImpl {
    private final Map<Class<?>, Injector> mInjectors;

    StateSaverImpl(Map<Class<?>, Injector> injectors) {
        this.mInjectors = injectors;
    }

    private Injector getInjector(Class<?> cls) {
        Injector injector = this.mInjectors.get(cls);
        if (injector != null || this.mInjectors.containsKey(cls)) {
            return injector;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            return null;
        }
        try {
            Class<?> injectorClass = Class.forName(clsName + "$$StateSaver");
            injector = (Injector)injectorClass.newInstance();
        }
        catch (Exception e) {
            injector = this.getInjector(cls.getSuperclass());
        }
        this.mInjectors.put(cls, injector);
        return injector;
    }

    private <T extends Injector> T safeGet(Object target, Injector nop) {
        try {
            Class<?> targetClass = target.getClass();
            Injector injector = this.getInjector(targetClass);
            if (injector == null) {
                injector = nop;
            }
            return (T)injector;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to inject state for " + target, e);
        }
    }

    <T> void saveInstanceState(@NonNull T target, @NonNull Bundle state) {
        Injector.Object injector = (Injector.Object)this.safeGet(target, Injector.Object.DEFAULT);
        injector.save(target, state);
    }

    <T> void restoreInstanceState(@NonNull T target, @Nullable Bundle state) {
        if (state != null) {
            Injector.Object injector = (Injector.Object)this.safeGet(target, Injector.Object.DEFAULT);
            injector.restore(target, state);
        }
    }

    @NonNull
    <T extends View> Parcelable saveInstanceState(@NonNull T target, @Nullable Parcelable state) {
        Injector.View injector = (Injector.View)this.safeGet(target, Injector.View.DEFAULT);
        return injector.save(target, state);
    }

    @Nullable
    <T extends View> Parcelable restoreInstanceState(@NonNull T target, @Nullable Parcelable state) {
        if (state != null) {
            Injector.View injector = (Injector.View)this.safeGet(target, Injector.View.DEFAULT);
            return injector.restore(target, state);
        }
        return null;
    }

    void setEnabledForAllActivitiesAndSupportFragments(@NonNull Application application, boolean enabled) {
        if (AndroidLifecycleCallbacks.INSTANCE.mEnabled != enabled) {
            if (enabled) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)AndroidLifecycleCallbacks.INSTANCE);
            } else {
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)AndroidLifecycleCallbacks.INSTANCE);
            }
            AndroidLifecycleCallbacks.INSTANCE.mEnabled = enabled;
        }
    }
}

