/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.qlack2.fuse.imaging.impl.util;

import com.eurodyn.qlack2.fuse.imaging.impl.util.MimeTypeFinder;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

public class ImageIOUtil {
    private static final Logger LOGGER = Logger.getLogger(ImageIOUtil.class.getName());
    private static final String default_format = "jpeg";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final int thumbnail_width = 70;
    private static final int thumbnail_height = 70;

    public static PlanarImage decodeImage(byte[] imageArray) throws IOException {
        LOGGER.log(Level.FINEST, "Decoding image");
        ByteArraySeekableStream stream = new ByteArraySeekableStream(imageArray);
        return JAI.create((String)"stream", (Object)stream);
    }

    public static byte[] encodeImage(PlanarImage pi, String format) {
        LOGGER.log(Level.FINEST, "Encoding image");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String disableMediaLib = System.getProperty("com.sun.media.jai.disableMediaLib");
        if (disableMediaLib == null || disableMediaLib.equals("false")) {
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        JAI.create((String)"encode", (RenderedImage)pi, (Object)stream, (Object)format);
        return stream.toByteArray();
    }

    public static String getFormat(byte[] image) {
        String format = default_format;
        Collection mimeTypeCollection = MimeTypeFinder.findMimeTypes(image);
        if (mimeTypeCollection.size() == 0) {
            LOGGER.log(Level.WARNING, "Image mimetype not found - returning default format");
            return format;
        }
        String mimeType = mimeTypeCollection.iterator().next().toString();
        if (mimeType.equals("image/bmp") || mimeType.equals("image/x-windows-bmp") || mimeType.equals("image/x-ms-bmp")) {
            format = "bmp";
        } else if (mimeType.equals("image/jpeg") || mimeType.equals("image/pjpeg")) {
            format = default_format;
        } else if (mimeType.equals("image/tiff") || mimeType.equals("image/x-tiff")) {
            format = "tiff";
        } else if (mimeType.equals("image/png")) {
            format = "png";
        } else {
            LOGGER.log(Level.WARNING, "Format for mimetype {0} not recognised - returning default format {1}", new String[]{mimeType, format});
        }
        return format;
    }

    public static String getMimeType(byte[] image) {
        String mimeType = DEFAULT_MIME_TYPE;
        Collection mimeTypeCollection = MimeTypeFinder.findMimeTypes(image);
        if (mimeTypeCollection.size() == 0) {
            LOGGER.log(Level.WARNING, "Image mimetype not found - returning default");
            return mimeType;
        }
        mimeType = mimeTypeCollection.iterator().next().toString();
        return mimeType;
    }
}

