/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.Field;
import com.ethlo.time.LeapSecondException;
import com.ethlo.time.TimezoneOffset;
import com.ethlo.time.internal.DateTimeFormatException;
import com.ethlo.time.internal.DateTimeMath;
import com.ethlo.time.internal.DefaultLeapSecondHandler;
import com.ethlo.time.internal.ITUFormatter;
import com.ethlo.time.internal.LeapSecondHandler;
import com.ethlo.time.internal.LimitedCharArrayIntegerUtil;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Objects;
import java.util.Optional;

public class DateTime
implements TemporalAccessor {
    private static final LeapSecondHandler leapSecondHandler = new DefaultLeapSecondHandler();
    private final Field field;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int nano;
    private final TimezoneOffset offset;
    private final int fractionDigits;
    private final int charLength;

    public DateTime(Field field, int year, int month, int day, int hour, int minute, int second, int nano, TimezoneOffset offset, int fractionDigits) {
        this(field, year, month, day, hour, minute, second, nano, offset, fractionDigits, -1);
    }

    public DateTime(Field field, int year, int month, int day, int hour, int minute, int second, int nano, TimezoneOffset offset, int fractionDigits, int charLength) {
        this.field = field;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.nano = nano;
        this.offset = offset;
        this.fractionDigits = fractionDigits;
        DateTime.leapSecondCheck(year, month, day, hour, minute, second, nano, offset);
        this.validated();
        this.charLength = charLength;
    }

    public static DateTime of(int year, int month, int day, int hour, int minute, int second, TimezoneOffset offset) {
        return new DateTime(Field.SECOND, year, month, day, hour, minute, second, 0, offset, 0);
    }

    public static DateTime of(int year, int month, int day, int hour, int minute, int second, int nanos, TimezoneOffset offset, int fractionDigits) {
        return new DateTime(Field.NANO, year, month, day, hour, minute, second, nanos, offset, fractionDigits);
    }

    public static DateTime ofYear(int year) {
        return new DateTime(Field.YEAR, year, 0, 0, 0, 0, 0, 0, null, 0);
    }

    public static DateTime ofYearMonth(int year, int month) {
        return new DateTime(Field.MONTH, year, month, 0, 0, 0, 0, 0, null, 0);
    }

    public static DateTime ofDate(int year, int month, int day) {
        return new DateTime(Field.DAY, year, month, day, 0, 0, 0, 0, null, 0);
    }

    public static DateTime of(int year, int month, int day, int hour, int minute, TimezoneOffset offset) {
        return new DateTime(Field.MINUTE, year, month, day, hour, minute, 0, 0, offset, 0);
    }

    public static DateTime of(OffsetDateTime dateTime) {
        return DateTime.of(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getNano(), TimezoneOffset.of(dateTime.getOffset()), 9);
    }

    private static void leapSecondCheck(int year, int month, int day, int hour, int minute, int second, int nanos, TimezoneOffset offset) {
        YearMonth needle;
        boolean isValidLeapYearMonth;
        if (second == 60 && ((isValidLeapYearMonth = leapSecondHandler.isValidLeapSecondDate(needle = YearMonth.of(year, month))) || needle.isAfter(leapSecondHandler.getLastKnownLeapSecond()))) {
            if (offset == null) {
                offset = TimezoneOffset.UTC;
            }
            int utcHour = hour - offset.getTotalSeconds() / 3600;
            int utcMinute = minute - offset.getTotalSeconds() % 3600 / 60;
            if ((month == Month.DECEMBER.getValue() && day == 31 || month == Month.JUNE.getValue() && day == 30) && utcHour == 23 && utcMinute == 59) {
                OffsetDateTime nearest = OffsetDateTime.of(year, month, day, hour, minute, 59, nanos, offset.toZoneOffset()).plusSeconds(1L);
                throw new LeapSecondException(nearest, second, isValidLeapYearMonth);
            }
        }
    }

    public boolean includesGranularity(Field field) {
        return field.ordinal() <= this.field.ordinal();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getNano() {
        return this.nano;
    }

    public Optional<TimezoneOffset> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public Year toYear() {
        return Year.of(this.year);
    }

    public YearMonth toYearMonth() {
        this.assertMinGranularity(Field.MONTH);
        return YearMonth.of(this.year, this.month);
    }

    public LocalDateTime toLocalDatetime() {
        this.assertMinGranularity(Field.MINUTE);
        return LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano);
    }

    public OffsetDateTime toOffsetDatetime() {
        this.assertMinGranularity(Field.MINUTE);
        if (this.offset != null) {
            return OffsetDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano, this.offset.toZoneOffset());
        }
        String chars = this.toString();
        throw new DateTimeParseException("No timezone information: " + chars, chars, chars.length());
    }

    public LocalDate toLocalDate() {
        this.assertMinGranularity(Field.DAY);
        return LocalDate.of(this.year, this.month, this.day);
    }

    public Field getMostGranularField() {
        return this.field;
    }

    private void assertMinGranularity(Field field) {
        if (!this.includesGranularity(field)) {
            throw new DateTimeFormatException("No " + field.name() + " field found");
        }
    }

    public String toString(Field lastIncluded) {
        return this.toString(this, lastIncluded, 0);
    }

    public String toString(int fractionDigits) {
        return this.toString(this, Field.NANO, fractionDigits);
    }

    private String toString(DateTime date, Field lastIncluded, int fractionDigits) {
        if (lastIncluded.ordinal() > date.getMostGranularField().ordinal()) {
            throw new DateTimeFormatException(String.format("Requested granularity was %s, but contains only granularity %s", lastIncluded.name(), date.getMostGranularField().name()));
        }
        TimezoneOffset tz = date.getOffset().orElse(null);
        char[] buffer = new char[35];
        LimitedCharArrayIntegerUtil.toString(date.getYear(), buffer, 0, 4);
        if (lastIncluded == Field.YEAR) {
            return ITUFormatter.finish(buffer, Field.YEAR.getRequiredLength(), null);
        }
        if (lastIncluded.ordinal() >= Field.MONTH.ordinal()) {
            buffer[4] = 45;
            LimitedCharArrayIntegerUtil.toString(date.getMonth(), buffer, 5, 2);
        }
        if (lastIncluded == Field.MONTH) {
            return ITUFormatter.finish(buffer, Field.MONTH.getRequiredLength(), null);
        }
        if (lastIncluded.ordinal() >= Field.DAY.ordinal()) {
            buffer[7] = 45;
            LimitedCharArrayIntegerUtil.toString(date.getDayOfMonth(), buffer, 8, 2);
        }
        if (lastIncluded == Field.DAY) {
            return ITUFormatter.finish(buffer, Field.DAY.getRequiredLength(), null);
        }
        if (lastIncluded.ordinal() >= Field.HOUR.ordinal()) {
            buffer[10] = 84;
            LimitedCharArrayIntegerUtil.toString(date.getHour(), buffer, 11, 2);
        }
        if (lastIncluded == Field.HOUR) {
            return ITUFormatter.finish(buffer, Field.HOUR.getRequiredLength(), tz);
        }
        if (lastIncluded.ordinal() >= Field.MINUTE.ordinal()) {
            buffer[13] = 58;
            LimitedCharArrayIntegerUtil.toString(date.getMinute(), buffer, 14, 2);
        }
        if (lastIncluded == Field.MINUTE) {
            return ITUFormatter.finish(buffer, Field.MINUTE.getRequiredLength(), tz);
        }
        if (lastIncluded.ordinal() >= Field.SECOND.ordinal()) {
            buffer[16] = 58;
            LimitedCharArrayIntegerUtil.toString(date.getSecond(), buffer, 17, 2);
        }
        if (lastIncluded == Field.SECOND) {
            return ITUFormatter.finish(buffer, Field.SECOND.getRequiredLength(), tz);
        }
        if (lastIncluded.ordinal() >= Field.NANO.ordinal()) {
            buffer[19] = 46;
            LimitedCharArrayIntegerUtil.toString(date.getNano(), buffer, 20, fractionDigits);
        }
        return ITUFormatter.finish(buffer, 20 + fractionDigits, tz);
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public String toString() {
        return this.fractionDigits > 0 ? this.toString(this.fractionDigits) : this.toString(this.field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)o;
        return this.year == dateTime.year && this.month == dateTime.month && this.day == dateTime.day && this.hour == dateTime.hour && this.minute == dateTime.minute && this.second == dateTime.second && this.nano == dateTime.nano && this.fractionDigits == dateTime.fractionDigits && this.field == dateTime.field && Objects.equals(this.offset, dateTime.offset);
    }

    public int hashCode() {
        return Objects.hash(this.field.ordinal(), this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano, this.offset, this.fractionDigits);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return Field.of(field).ordinal() <= this.field.ordinal();
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField.equals(ChronoField.YEAR)) {
            return this.year;
        }
        if (temporalField.equals(ChronoField.MONTH_OF_YEAR)) {
            return this.month;
        }
        if (temporalField.equals(ChronoField.DAY_OF_MONTH)) {
            return this.day;
        }
        if (temporalField.equals(ChronoField.HOUR_OF_DAY)) {
            return this.hour;
        }
        if (temporalField.equals(ChronoField.MINUTE_OF_HOUR)) {
            return this.minute;
        }
        if (temporalField.equals(ChronoField.SECOND_OF_MINUTE)) {
            return this.second;
        }
        if (temporalField.equals(ChronoField.NANO_OF_SECOND)) {
            return this.nano;
        }
        if (temporalField.equals(ChronoField.INSTANT_SECONDS) && this.offset != null) {
            return this.toEpochSeconds();
        }
        throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
    }

    public Instant toInstant() {
        return Instant.ofEpochSecond(this.toEpochSeconds(), this.nano);
    }

    private long toEpochSeconds() {
        long secsSinceMidnight = (long)this.hour * 3600L + (long)this.minute * 60L + (long)this.second;
        long daysInSeconds = DateTimeMath.daysFromCivil(this.year, this.month != 0 ? this.month : 1, this.day != 0 ? this.day : 1) * 86400L;
        long tsOffset = this.offset != null ? (long)this.offset.getTotalSeconds() : 0L;
        return daysInSeconds + secsSinceMidnight - tsOffset;
    }

    private void validated() {
        if (this.field.ordinal() >= Field.DAY.ordinal()) {
            LocalDate.of(this.year, this.month, this.day);
        }
        if (this.second > 59) {
            throw new DateTimeException(String.format("Invalid value for SecondOfMinute (valid values 0 - 59): %d", this.second));
        }
    }

    public int getParseLength() {
        return this.charLength;
    }
}

