/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.AbstractRfc3339;
import com.ethlo.time.Field;
import com.ethlo.time.Java8Rfc3339;
import com.ethlo.time.LeapSecondException;
import com.ethlo.time.LimitedCharArrayIntegerUtil;
import com.ethlo.time.W3cDateTimeUtil;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public class EthloITU
extends AbstractRfc3339
implements W3cDateTimeUtil {
    public static final int LEAP_SECOND_SECONDS = 60;
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char DATE_SEPARATOR = '-';
    private static final char TIME_SEPARATOR = ':';
    private static final char SEPARATOR_UPPER = 'T';
    private static final char SEPARATOR_LOWER = 't';
    private static final char SEPARATOR_SPACE = ' ';
    private static final char FRACTION_SEPARATOR = '.';
    private static final char ZULU_UPPER = 'Z';
    private static final char ZULU_LOWER = 'z';
    private static final int[] widths = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private final Java8Rfc3339 delegate = new Java8Rfc3339();

    @Override
    public OffsetDateTime parseDateTime(String text) {
        Objects.requireNonNull(text, "text");
        char[] chars = text.toCharArray();
        int year = this.getYear(chars);
        this.assertPositionContains(chars, 4, '-');
        int month = this.getMonth(chars);
        this.assertPositionContains(chars, 7, '-');
        int day = this.getDay(chars);
        this.assertPositionContains(chars, 10, 'T', 't', ' ');
        int hour = this.getHour(chars);
        this.assertPositionContains(chars, 13, ':');
        int minute = this.getMinute(chars);
        return this.handleTime(chars, year, month, day, hour, minute);
    }

    private int getHour(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 11, 13);
    }

    private int getMinute(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 14, 16);
    }

    private int getDay(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 8, 10);
    }

    private OffsetDateTime handleTime(char[] chars, int year, int month, int day, int hour, int minute) {
        switch (chars[16]) {
            case ':': {
                return this.seconds(year, month, day, hour, minute, chars);
            }
            case '+': 
            case '-': 
            case 'Z': 
            case 'z': {
                ZoneOffset zoneOffset = this.parseTz(chars, 16);
                return OffsetDateTime.of(year, month, day, hour, minute, 0, 0, zoneOffset);
            }
        }
        this.assertPositionContains(chars, 16, ':', '+', '-', 'Z');
        throw new DateTimeException(new String(chars));
    }

    private void assertPositionContains(char[] chars, int offset, char expected) {
        if (offset >= chars.length) {
            throw new DateTimeException("Abrupt end of input: " + new String(chars));
        }
        if (chars[offset] != expected) {
            throw new DateTimeException("Expected character " + expected + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private void assertPositionContains(char[] chars, int offset, char ... expected) {
        if (offset >= chars.length) {
            throw new DateTimeException("Abrupt end of input: " + new String(chars));
        }
        boolean found = false;
        for (char e : expected) {
            if (chars[offset] != e) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new DateTimeException("Expected character " + Arrays.toString(expected) + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private ZoneOffset parseTz(char[] chars, int offset) {
        int left = chars.length - offset;
        if (chars[offset] == 'Z' || chars[offset] == 'z') {
            this.assertNoMoreChars(chars, offset);
            return ZoneOffset.UTC;
        }
        if (left != 6) {
            throw new DateTimeException("Invalid timezone offset: " + new String(chars, offset, left));
        }
        char sign = chars[offset];
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 1, offset + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 4, offset + 4 + 2);
        if (sign == '-') {
            hours = -hours;
        } else if (sign != '+') {
            throw new DateTimeException("Invalid character starting at position " + offset + 1);
        }
        if (sign == '-' && hours == 0 && minutes == 0) {
            throw new DateTimeException("Unknown 'Local Offset Convention' date-time not allowed");
        }
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private void assertNoMoreChars(char[] chars, int lastUsed) {
        if (chars.length > lastUsed + 1) {
            throw new DateTimeException("Unparsed data from offset " + lastUsed + 1);
        }
    }

    @Override
    public String formatUtc(OffsetDateTime date, int fractionDigits) {
        return this.formatUtc(date, Field.SECOND, fractionDigits);
    }

    @Override
    public String format(OffsetDateTime date, Field lastIncluded) {
        return this.formatUtc(date, lastIncluded, 0);
    }

    @Override
    public String formatUtc(OffsetDateTime date, Field lastIncluded, int fractionDigits) {
        boolean hasFractionDigits;
        this.assertMaxFractionDigits(fractionDigits);
        ZonedDateTime utc = date.atZoneSameInstant(ZoneOffset.UTC);
        char[] buffer = new char[31];
        if (this.handleDatePart(lastIncluded, buffer, utc.getYear(), 0, 4, Field.YEAR)) {
            return this.finish(buffer, Field.YEAR.getRequiredLength());
        }
        buffer[4] = 45;
        if (this.handleDatePart(lastIncluded, buffer, utc.getMonthValue(), 5, 2, Field.MONTH)) {
            return this.finish(buffer, Field.MONTH.getRequiredLength());
        }
        buffer[7] = 45;
        if (this.handleDatePart(lastIncluded, buffer, utc.getDayOfMonth(), 8, 2, Field.DAY)) {
            return this.finish(buffer, Field.DAY.getRequiredLength());
        }
        buffer[10] = 84;
        LimitedCharArrayIntegerUtil.toString(utc.getHour(), buffer, 11, 2);
        buffer[13] = 58;
        if (this.handleDatePart(lastIncluded, buffer, utc.getMinute(), 14, 2, Field.MINUTE)) {
            return this.finish(buffer, Field.MINUTE.getRequiredLength());
        }
        buffer[16] = 58;
        LimitedCharArrayIntegerUtil.toString(utc.getSecond(), buffer, 17, 2);
        boolean bl = hasFractionDigits = fractionDigits > 0;
        if (hasFractionDigits) {
            buffer[19] = 46;
            this.addFractions(buffer, fractionDigits, utc.getNano());
        }
        int length = this.addUtcTimezone(fractionDigits, buffer, hasFractionDigits);
        return this.finish(buffer, length);
    }

    private int addUtcTimezone(int fractionDigits, char[] buf, boolean hasFractionDigits) {
        buf[hasFractionDigits ? 20 + fractionDigits : 19] = 90;
        return hasFractionDigits ? 21 + fractionDigits : 20;
    }

    private boolean handleDatePart(Field lastIncluded, char[] buffer, int value, int offset, int length, Field field) {
        LimitedCharArrayIntegerUtil.toString(value, buffer, offset, length);
        return lastIncluded == field;
    }

    private String finish(char[] buf, int length) {
        return new String(buf, 0, length);
    }

    private void addFractions(char[] buf, int fractionDigits, int nano) {
        double d = widths[fractionDigits - 1];
        LimitedCharArrayIntegerUtil.toString((int)((double)nano / d), buf, 20, fractionDigits);
    }

    @Override
    public String formatUtc(Date date) {
        return this.formatUtc(OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC), 3);
    }

    @Override
    public String format(Date date, String timezone) {
        return this.delegate.format(date, timezone);
    }

    @Override
    public boolean isValid(String dateTime) {
        try {
            this.parseDateTime(dateTime);
            return true;
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    @Override
    public String formatUtcMilli(OffsetDateTime date) {
        return this.formatUtc(date, 3);
    }

    @Override
    public String formatUtcMicro(OffsetDateTime date) {
        return this.formatUtc(date, 6);
    }

    @Override
    public String formatUtcNano(OffsetDateTime date) {
        return this.formatUtc(date, 9);
    }

    @Override
    public String formatUtc(OffsetDateTime date) {
        return this.formatUtc(date, 0);
    }

    @Override
    public String formatUtcMilli(Date date) {
        return this.formatUtcMilli(OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC));
    }

    @Override
    public String format(Date date, String timezone, int fractionDigits) {
        return this.delegate.format(date, timezone, fractionDigits);
    }

    @Override
    public Temporal parseLenient(String s) {
        return this.doParseLenient(s, null);
    }

    @Override
    public <T extends Temporal> T parseLenient(String s, Class<T> type) {
        return (T)((Temporal)type.cast(this.doParseLenient(s, type)));
    }

    public <T extends Temporal> Temporal doParseLenient(String s, Class<T> type) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        Field maxRequired = type == null ? null : Field.valueOf(type);
        char[] chars = s.toCharArray();
        int year = this.getYear(chars);
        if (maxRequired == Field.YEAR || chars.length == 4) {
            return Year.of(year);
        }
        this.assertPositionContains(chars, 4, '-');
        int month = this.getMonth(chars);
        if (maxRequired == Field.MONTH || chars.length == 7) {
            return YearMonth.of(year, month);
        }
        this.assertPositionContains(chars, 7, '-');
        int day = this.getDay(chars);
        if (maxRequired == Field.DAY || chars.length == 10) {
            return LocalDate.of(year, month, day);
        }
        this.assertPositionContains(chars, 10, 'T', 't', ' ');
        int hour = this.getHour(chars);
        this.assertPositionContains(chars, 13, ':');
        int minute = this.getMinute(chars);
        if (maxRequired == Field.MINUTE || chars.length == 16) {
            return LocalDate.of(year, month, day);
        }
        return this.handleTime(chars, year, month, day, hour, minute);
    }

    private int getMonth(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 5, 7);
    }

    private int getYear(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 0, 4);
    }

    private OffsetDateTime seconds(int year, int month, int day, int hour, int minute, char[] chars) {
        ZoneOffset offset;
        int second = this.getSecond(chars);
        int remaining = chars.length - 19;
        int fractions = 0;
        if (remaining == 1 && (chars[19] == 'Z' || chars[19] == 'z')) {
            offset = ZoneOffset.UTC;
            this.assertNoMoreChars(chars, 19);
        } else if (remaining >= 1 && chars[19] == '.') {
            int idx = LimitedCharArrayIntegerUtil.indexOfNonDigit(chars, 20);
            if (idx != -1) {
                int len = idx - 20;
                fractions = this.getFractions(chars, idx, len);
                offset = this.parseTz(chars, idx);
            } else {
                offset = this.parseTz(chars, 20);
            }
        } else if (remaining >= 1 && (chars[19] == '+' || chars[19] == '-')) {
            offset = this.parseTz(chars, 19);
        } else {
            if (remaining == 0) {
                throw new DateTimeException("Unexpected end of expression at position 19 '" + new String(chars) + "'");
            }
            throw new DateTimeException("Unexpected character at position 19:" + chars[19]);
        }
        if (second == 60) {
            int utcHour = hour - offset.getTotalSeconds() / 3600;
            int utcMinute = minute - offset.getTotalSeconds() % 3600 / 60;
            if ((month == Month.DECEMBER.getValue() && day == 31 || month == Month.JUNE.getValue() && day == 30) && utcHour == 23 && utcMinute == 59) {
                throw new LeapSecondException(OffsetDateTime.of(year, month, day, hour, minute, 59, fractions, offset).plusSeconds(1L), second);
            }
        }
        return OffsetDateTime.of(year, month, day, hour, minute, second, fractions, offset);
    }

    private int getSecond(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 17, 19);
    }

    private int getFractions(char[] chars, int idx, int len) {
        int fractions = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 20, idx);
        switch (len) {
            case 1: {
                return fractions * 100000000;
            }
            case 2: {
                return fractions * 10000000;
            }
            case 3: {
                return fractions * 1000000;
            }
            case 4: {
                return fractions * 100000;
            }
            case 5: {
                return fractions * 10000;
            }
            case 6: {
                return fractions * 1000;
            }
            case 7: {
                return fractions * 100;
            }
            case 8: {
                return fractions * 10;
            }
        }
        return fractions;
    }
}

