/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import java.util.Arrays;
import java.util.Optional;

public class ParseConfig {
    private static final char[] DEFAULT_DATE_TIME_SEPARATORS = new char[]{'T', 't', ' '};
    private static final char[] RFC_3339_FRACTION_SEPARATOR = new char[]{'.'};
    public static final ParseConfig DEFAULT = new ParseConfig(DEFAULT_DATE_TIME_SEPARATORS, RFC_3339_FRACTION_SEPARATOR);
    public static final ParseConfig STRICT = new ParseConfig(new char[]{'T'}, RFC_3339_FRACTION_SEPARATOR);
    private final char[] dateTimeSeparators;
    private final char[] fractionSeparators;

    protected ParseConfig(char[] dateTimeSeparators, char[] allowedFractionSeparators) {
        this.dateTimeSeparators = Optional.ofNullable(dateTimeSeparators).orElse(DEFAULT_DATE_TIME_SEPARATORS);
        this.fractionSeparators = Optional.ofNullable(allowedFractionSeparators).orElse(RFC_3339_FRACTION_SEPARATOR);
    }

    public char[] getFractionSeparators() {
        return this.fractionSeparators;
    }

    public ParseConfig withDateTimeSeparators(char ... allowed) {
        this.assertChars(allowed);
        return new ParseConfig(allowed, this.fractionSeparators);
    }

    private void assertChars(char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Cannot have null array of characters");
        }
        if (chars.length == 0) {
            throw new IllegalArgumentException("Must have at least one character in allowed list");
        }
    }

    public ParseConfig withFractionSeparators(char ... allowed) {
        this.assertChars(allowed);
        return new ParseConfig(this.dateTimeSeparators, allowed);
    }

    public ParseConfig withFailOnTrailingJunk(boolean failOnTrailingJunk) {
        return new ParseConfig(this.dateTimeSeparators, this.fractionSeparators);
    }

    public boolean isFailOnTrailingJunk() {
        return true;
    }

    public char[] getDateTimeSeparators() {
        return this.dateTimeSeparators;
    }

    public boolean isDateTimeSeparator(char needle) {
        for (char c : this.dateTimeSeparators) {
            if (c != needle) continue;
            return true;
        }
        return false;
    }

    public boolean isFractionSeparator(char needle) {
        for (char c : this.fractionSeparators) {
            if (c != needle) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ParseConfig{dateTimeSeparators=" + Arrays.toString(this.dateTimeSeparators) + ", fractionSeparators=" + Arrays.toString(this.fractionSeparators) + "}";
    }
}

