/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorExportToWkb;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class OperatorExportToWkbLocal
extends OperatorExportToWkb {
    OperatorExportToWkbLocal() {
    }

    @Override
    public ByteBuffer execute(int exportFlags, Geometry geometry, ProgressTracker progressTracker) {
        int size = OperatorExportToWkbLocal.exportToWKB(exportFlags, geometry, null);
        ByteBuffer wkbBuffer = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        OperatorExportToWkbLocal.exportToWKB(exportFlags, geometry, wkbBuffer);
        return wkbBuffer;
    }

    @Override
    public int execute(int exportFlags, Geometry geometry, ByteBuffer wkbBuffer, ProgressTracker progressTracker) {
        return OperatorExportToWkbLocal.exportToWKB(exportFlags, geometry, wkbBuffer);
    }

    private static int exportToWKB(int exportFlags, Geometry geometry, ByteBuffer wkbBuffer) {
        if (geometry == null) {
            return 0;
        }
        int type = geometry.getType().value();
        switch (type) {
            case 1736: {
                if ((exportFlags & 4) != 0 || (exportFlags & 8) != 0 || (exportFlags & 1) != 0 || (exportFlags & 2) != 0) {
                    throw new GeometryException("invalid argument");
                }
                return OperatorExportToWkbLocal.exportPolygonToWKB(exportFlags, (Polygon)geometry, wkbBuffer);
            }
            case 1607: {
                if ((exportFlags & 0x10) != 0 || (exportFlags & 0x20) != 0 || (exportFlags & 1) != 0 || (exportFlags & 2) != 0) {
                    throw new GeometryException("invalid argument");
                }
                return OperatorExportToWkbLocal.exportPolylineToWKB(exportFlags, (Polyline)geometry, wkbBuffer);
            }
            case 550: {
                if ((exportFlags & 4) != 0 || (exportFlags & 8) != 0 || (exportFlags & 0x10) != 0 || (exportFlags & 0x20) != 0) {
                    throw new GeometryException("invalid argument");
                }
                return OperatorExportToWkbLocal.exportMultiPointToWKB(exportFlags, (MultiPoint)geometry, wkbBuffer);
            }
            case 33: {
                if ((exportFlags & 4) != 0 || (exportFlags & 8) != 0 || (exportFlags & 0x10) != 0 || (exportFlags & 0x20) != 0) {
                    throw new GeometryException("invalid argument");
                }
                return OperatorExportToWkbLocal.exportPointToWKB(exportFlags, (Point)geometry, wkbBuffer);
            }
            case 197: {
                if ((exportFlags & 4) != 0 || (exportFlags & 8) != 0 || (exportFlags & 1) != 0 || (exportFlags & 2) != 0) {
                    throw new GeometryException("invalid argument");
                }
                return OperatorExportToWkbLocal.exportEnvelopeToWKB(exportFlags, (Envelope)geometry, wkbBuffer);
            }
        }
        throw new GeometryException("internal error");
    }

    private static int exportPolygonToWKB(int exportFlags, Polygon _polygon, ByteBuffer wkbBuffer) {
        int type;
        int simple;
        MultiPathImpl polygon = (MultiPathImpl)_polygon._getImpl();
        if ((exportFlags & 0x1000) != 0 && (simple = polygon.getIsSimple(0.0)) != 2) {
            throw new GeometryException("non simple geometry");
        }
        boolean bExportZs = polygon.hasAttribute(1) && (exportFlags & 0x40) == 0;
        boolean bExportMs = polygon.hasAttribute(2) && (exportFlags & 0x80) == 0;
        int polygonCount = polygon.getOGCPolygonCount();
        if ((exportFlags & 0x10) != 0 && polygonCount > 1) {
            throw new IllegalArgumentException();
        }
        int partCount = polygon.getPathCount();
        int point_count = polygon.getPointCount();
        if ((point_count += partCount) > 0 && polygonCount == 0) {
            throw new GeometryException("corrupted geometry");
        }
        int size = 0;
        if ((exportFlags & 0x10) == 0 || polygonCount == 0) {
            size += 9;
        }
        size += polygonCount * 9 + partCount * 4 + point_count * 16;
        if (bExportZs) {
            size += point_count * 8;
        }
        if (bExportMs) {
            size += point_count * 8;
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (wkbBuffer == null) {
            return size;
        }
        if (wkbBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int offset = 0;
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        if (!bExportZs && !bExportMs) {
            type = 3;
            if ((exportFlags & 0x10) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 6);
                wkbBuffer.putInt(offset += 4, polygonCount);
                offset += 4;
            } else if (polygonCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else if (bExportZs && !bExportMs) {
            type = 1003;
            if ((exportFlags & 0x10) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1006);
                wkbBuffer.putInt(offset += 4, polygonCount);
                offset += 4;
            } else if (polygonCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1003);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else if (bExportMs && !bExportZs) {
            type = 2003;
            if ((exportFlags & 0x10) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2006);
                wkbBuffer.putInt(offset += 4, polygonCount);
                offset += 4;
            } else if (polygonCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2003);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else {
            type = 3003;
            if ((exportFlags & 0x10) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3006);
                wkbBuffer.putInt(offset += 4, polygonCount);
                offset += 4;
            } else if (polygonCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3003);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        }
        if (polygonCount == 0) {
            return offset;
        }
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)polygon.getAttributeStreamRef(0);
        AttributeStreamOfDbl zs = null;
        if (bExportZs && polygon._attributeStreamIsAllocated(1)) {
            zs = (AttributeStreamOfDbl)polygon.getAttributeStreamRef(1);
        }
        AttributeStreamOfDbl ms = null;
        if (bExportMs && polygon._attributeStreamIsAllocated(2)) {
            ms = (AttributeStreamOfDbl)polygon.getAttributeStreamRef(2);
        }
        int ipartend = 0;
        int ipolygonend = 0;
        for (int ipolygon = 0; ipolygon < polygonCount; ++ipolygon) {
            wkbBuffer.put(offset, byteOrder);
            wkbBuffer.putInt(++offset, type);
            offset += 4;
            AttributeStreamOfInt8 pathFlags = polygon.getPathFlagsStreamRef();
            int ipolygonstart = ipolygonend++;
            while (ipolygonend < partCount && (pathFlags.read(ipolygonend) & 4) == 0) {
                ++ipolygonend;
            }
            wkbBuffer.putInt(offset, ipolygonend - ipolygonstart);
            offset += 4;
            for (int ipart = ipolygonstart; ipart < ipolygonend; ++ipart) {
                int ipartstart = ipartend;
                ipartend = polygon.getPathEnd(ipart);
                wkbBuffer.putInt(offset, ipartend - ipartstart + 1);
                double x = position.read(2 * ipartstart);
                double y = position.read(2 * ipartstart + 1);
                wkbBuffer.putDouble(offset += 4, x);
                wkbBuffer.putDouble(offset += 8, y);
                offset += 8;
                if (bExportZs) {
                    double z = zs != null ? zs.read(ipartstart) : VertexDescription.getDefaultValue(1);
                    wkbBuffer.putDouble(offset, z);
                    offset += 8;
                }
                if (bExportMs) {
                    double m = ms != null ? ms.read(ipartstart) : VertexDescription.getDefaultValue(2);
                    wkbBuffer.putDouble(offset, m);
                    offset += 8;
                }
                for (int i = ipartend - 1; i >= ipartstart; --i) {
                    x = position.read(2 * i);
                    y = position.read(2 * i + 1);
                    wkbBuffer.putDouble(offset, x);
                    wkbBuffer.putDouble(offset += 8, y);
                    offset += 8;
                    if (bExportZs) {
                        double z = zs != null ? zs.read(i) : VertexDescription.getDefaultValue(1);
                        wkbBuffer.putDouble(offset, z);
                        offset += 8;
                    }
                    if (!bExportMs) continue;
                    double m = ms != null ? ms.read(i) : VertexDescription.getDefaultValue(2);
                    wkbBuffer.putDouble(offset, m);
                    offset += 8;
                }
            }
        }
        return offset;
    }

    private static int exportPolylineToWKB(int exportFlags, Polyline _polyline, ByteBuffer wkbBuffer) {
        int type;
        int simple;
        MultiPathImpl polyline = (MultiPathImpl)_polyline._getImpl();
        if ((exportFlags & 0x1000) != 0 && (simple = polyline.getIsSimple(0.0)) < 1) {
            throw new GeometryException("corrupted geometry");
        }
        boolean bExportZs = polyline.hasAttribute(1) && (exportFlags & 0x40) == 0;
        boolean bExportMs = polyline.hasAttribute(2) && (exportFlags & 0x80) == 0;
        int partCount = polyline.getPathCount();
        if ((exportFlags & 4) != 0 && partCount > 1) {
            throw new IllegalArgumentException();
        }
        int point_count = polyline.getPointCount();
        for (int ipart = 0; ipart < partCount; ++ipart) {
            if (!polyline.isClosedPath(ipart)) continue;
            ++point_count;
        }
        int size = 0;
        if ((exportFlags & 4) == 0 || partCount == 0) {
            size += 9;
        }
        size += partCount * 9 + point_count * 16;
        if (bExportZs) {
            size += point_count * 8;
        }
        if (bExportMs) {
            size += point_count * 8;
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (wkbBuffer == null) {
            return size;
        }
        if (wkbBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int offset = 0;
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        if (!bExportZs && !bExportMs) {
            type = 2;
            if ((exportFlags & 4) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 5);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else if (bExportZs && !bExportMs) {
            type = 1002;
            if ((exportFlags & 4) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1005);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1002);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else if (bExportMs && !bExportZs) {
            type = 2002;
            if ((exportFlags & 4) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2005);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2002);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else {
            type = 3002;
            if ((exportFlags & 4) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3005);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3002);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        }
        if (partCount == 0) {
            return offset;
        }
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)polyline.getAttributeStreamRef(0);
        AttributeStreamOfDbl zs = null;
        if (bExportZs && polyline._attributeStreamIsAllocated(1)) {
            zs = (AttributeStreamOfDbl)polyline.getAttributeStreamRef(1);
        }
        AttributeStreamOfDbl ms = null;
        if (bExportMs && polyline._attributeStreamIsAllocated(2)) {
            ms = (AttributeStreamOfDbl)polyline.getAttributeStreamRef(2);
        }
        int ipartend = 0;
        for (int ipart = 0; ipart < partCount; ++ipart) {
            wkbBuffer.put(offset, byteOrder);
            wkbBuffer.putInt(++offset, type);
            offset += 4;
            int ipartstart = ipartend;
            ipartend = polyline.getPathEnd(ipart);
            int num_points = ipartend - ipartstart;
            if (polyline.isClosedPath(ipart)) {
                ++num_points;
            }
            wkbBuffer.putInt(offset, num_points);
            offset += 4;
            for (int i = ipartstart; i < ipartend; ++i) {
                double x = position.read(2 * i);
                double y = position.read(2 * i + 1);
                wkbBuffer.putDouble(offset, x);
                wkbBuffer.putDouble(offset += 8, y);
                offset += 8;
                if (bExportZs) {
                    double z = zs != null ? zs.read(i) : VertexDescription.getDefaultValue(1);
                    wkbBuffer.putDouble(offset, z);
                    offset += 8;
                }
                if (!bExportMs) continue;
                double m = ms != null ? ms.read(i) : VertexDescription.getDefaultValue(2);
                wkbBuffer.putDouble(offset, m);
                offset += 8;
            }
            if (!polyline.isClosedPath(ipart)) continue;
            double x = position.read(2 * ipartstart);
            double y = position.read(2 * ipartstart + 1);
            wkbBuffer.putDouble(offset, x);
            wkbBuffer.putDouble(offset += 8, y);
            offset += 8;
            if (bExportZs) {
                double z = zs != null ? zs.read(ipartstart) : VertexDescription.getDefaultValue(1);
                wkbBuffer.putDouble(offset, z);
                offset += 8;
            }
            if (!bExportMs) continue;
            double m = ms != null ? ms.read(ipartstart) : VertexDescription.getDefaultValue(2);
            wkbBuffer.putDouble(offset, m);
            offset += 8;
        }
        return offset;
    }

    private static int exportMultiPointToWKB(int exportFlags, MultiPoint _multipoint, ByteBuffer wkbBuffer) {
        int type;
        int size;
        MultiPointImpl multipoint = (MultiPointImpl)_multipoint._getImpl();
        boolean bExportZs = multipoint.hasAttribute(1) && (exportFlags & 0x40) == 0;
        boolean bExportMs = multipoint.hasAttribute(2) && (exportFlags & 0x80) == 0;
        int point_count = multipoint.getPointCount();
        if ((exportFlags & 1) != 0 && point_count > 1) {
            throw new IllegalArgumentException();
        }
        if ((exportFlags & 1) == 0) {
            size = 9 + point_count * 21;
            if (bExportZs) {
                size += point_count * 8;
            }
            if (bExportMs) {
                size += point_count * 8;
            }
        } else {
            size = 21;
            if (bExportZs) {
                size += 8;
            }
            if (bExportMs) {
                size += 8;
            }
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (wkbBuffer == null) {
            return size;
        }
        if (wkbBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int offset = 0;
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        if (!bExportZs && !bExportMs) {
            type = 1;
            if ((exportFlags & 1) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 4);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        } else if (bExportZs && !bExportMs) {
            type = 1001;
            if ((exportFlags & 1) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1004);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        } else if (bExportMs && !bExportZs) {
            type = 2001;
            if ((exportFlags & 1) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2004);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        } else {
            type = 3001;
            if ((exportFlags & 1) == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3006);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        }
        if (point_count == 0) {
            return offset;
        }
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)multipoint.getAttributeStreamRef(0);
        AttributeStreamOfDbl zs = null;
        if (bExportZs && multipoint._attributeStreamIsAllocated(1)) {
            zs = (AttributeStreamOfDbl)multipoint.getAttributeStreamRef(1);
        }
        AttributeStreamOfDbl ms = null;
        if (bExportMs && multipoint._attributeStreamIsAllocated(2)) {
            ms = (AttributeStreamOfDbl)multipoint.getAttributeStreamRef(2);
        }
        for (int i = 0; i < point_count; ++i) {
            wkbBuffer.put(offset, byteOrder);
            wkbBuffer.putInt(++offset, type);
            double x = position.read(2 * i);
            double y = position.read(2 * i + 1);
            wkbBuffer.putDouble(offset += 4, x);
            wkbBuffer.putDouble(offset += 8, y);
            offset += 8;
            if (bExportZs) {
                double z = zs != null ? zs.read(i) : VertexDescription.getDefaultValue(1);
                wkbBuffer.putDouble(offset, z);
                offset += 8;
            }
            if (!bExportMs) continue;
            double m = ms != null ? ms.read(i) : VertexDescription.getDefaultValue(2);
            wkbBuffer.putDouble(offset, m);
            offset += 8;
        }
        return offset;
    }

    private static int exportPointToWKB(int exportFlags, Point point, ByteBuffer wkbBuffer) {
        int type;
        int size;
        int point_count;
        boolean bExportZs = point.hasAttribute(1) && (exportFlags & 0x40) == 0;
        boolean bExportMs = point.hasAttribute(2) && (exportFlags & 0x80) == 0;
        boolean bEmpty = point.isEmpty();
        int n = point_count = bEmpty ? 0 : 1;
        if ((exportFlags & 2) != 0) {
            size = 9 + point_count * 21;
            if (bExportZs) {
                size += point_count * 8;
            }
            if (bExportMs) {
                size += point_count * 8;
            }
        } else {
            size = 21;
            if (bExportZs) {
                size += 8;
            }
            if (bExportMs) {
                size += 8;
            }
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (wkbBuffer == null) {
            return size;
        }
        if (wkbBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int offset = 0;
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        if (!bExportZs && !bExportMs) {
            type = 1;
            if ((exportFlags & 2) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 4);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        } else if (bExportZs && !bExportMs) {
            type = 1001;
            if ((exportFlags & 2) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1004);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        } else if (bExportMs && !bExportZs) {
            type = 2001;
            if ((exportFlags & 2) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2004);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        } else {
            type = 3001;
            if ((exportFlags & 2) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3004);
                wkbBuffer.putInt(offset += 4, point_count);
                offset += 4;
            } else if (point_count == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, type);
                wkbBuffer.putDouble(offset += 4, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                wkbBuffer.putDouble(offset += 8, Double.NaN);
                offset += 8;
            }
        }
        if (point_count == 0) {
            return offset;
        }
        wkbBuffer.put(offset, byteOrder);
        wkbBuffer.putInt(++offset, type);
        double x = point.getX();
        double y = point.getY();
        wkbBuffer.putDouble(offset += 4, x);
        wkbBuffer.putDouble(offset += 8, y);
        offset += 8;
        if (bExportZs) {
            double z = point.getZ();
            wkbBuffer.putDouble(offset, z);
            offset += 8;
        }
        if (bExportMs) {
            double m = point.getM();
            wkbBuffer.putDouble(offset, m);
            offset += 8;
        }
        return offset;
    }

    private static int exportEnvelopeToWKB(int exportFlags, Envelope envelope, ByteBuffer wkbBuffer) {
        int type;
        boolean bExportZs = envelope.hasAttribute(1) && (exportFlags & 0x40) == 0;
        boolean bExportMs = envelope.hasAttribute(2) && (exportFlags & 0x80) == 0;
        boolean bEmpty = envelope.isEmpty();
        int partCount = bEmpty ? 0 : 1;
        int point_count = bEmpty ? 0 : 5;
        int size = 0;
        if ((exportFlags & 0x20) != 0 || partCount == 0) {
            size += 9;
        }
        size += partCount * 9 + partCount * 4 + point_count * 16;
        if (bExportZs) {
            size += point_count * 8;
        }
        if (bExportMs) {
            size += point_count * 8;
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (wkbBuffer == null) {
            return size;
        }
        if (wkbBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int offset = 0;
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        if (!bExportZs && !bExportMs) {
            type = 3;
            if ((exportFlags & 0x20) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 6);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else if (bExportZs && !bExportMs) {
            type = 1003;
            if ((exportFlags & 0x10) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1006);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 1003);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else if (bExportMs && !bExportZs) {
            type = 2003;
            if ((exportFlags & 0x20) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2006);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 2003);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        } else {
            type = 3003;
            if ((exportFlags & 0x20) != 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3006);
                wkbBuffer.putInt(offset += 4, partCount);
                offset += 4;
            } else if (partCount == 0) {
                wkbBuffer.put(offset, byteOrder);
                wkbBuffer.putInt(++offset, 3003);
                wkbBuffer.putInt(offset += 4, 0);
                offset += 4;
            }
        }
        if (partCount == 0) {
            return offset;
        }
        wkbBuffer.put(offset, byteOrder);
        wkbBuffer.putInt(++offset, type);
        wkbBuffer.putInt(offset += 4, 1);
        wkbBuffer.putInt(offset += 4, 5);
        offset += 4;
        Envelope2D env = new Envelope2D();
        envelope.queryEnvelope2D(env);
        Envelope1D z_interval = null;
        if (bExportZs) {
            z_interval = envelope.queryInterval(1, 0);
        }
        Envelope1D mInterval = null;
        if (bExportMs) {
            mInterval = envelope.queryInterval(2, 0);
        }
        wkbBuffer.putDouble(offset, env.xmin);
        wkbBuffer.putDouble(offset += 8, env.ymin);
        offset += 8;
        if (bExportZs) {
            wkbBuffer.putDouble(offset, z_interval.vmin);
            offset += 8;
        }
        if (bExportMs) {
            wkbBuffer.putDouble(offset, mInterval.vmin);
            offset += 8;
        }
        wkbBuffer.putDouble(offset, env.xmax);
        wkbBuffer.putDouble(offset += 8, env.ymin);
        offset += 8;
        if (bExportZs) {
            wkbBuffer.putDouble(offset, z_interval.vmax);
            offset += 8;
        }
        if (bExportMs) {
            wkbBuffer.putDouble(offset, mInterval.vmax);
            offset += 8;
        }
        wkbBuffer.putDouble(offset, env.xmax);
        wkbBuffer.putDouble(offset += 8, env.ymax);
        offset += 8;
        if (bExportZs) {
            wkbBuffer.putDouble(offset, z_interval.vmin);
            offset += 8;
        }
        if (bExportMs) {
            wkbBuffer.putDouble(offset, mInterval.vmin);
            offset += 8;
        }
        wkbBuffer.putDouble(offset, env.xmin);
        wkbBuffer.putDouble(offset += 8, env.ymax);
        offset += 8;
        if (bExportZs) {
            wkbBuffer.putDouble(offset, z_interval.vmax);
            offset += 8;
        }
        if (bExportMs) {
            wkbBuffer.putDouble(offset, mInterval.vmax);
            offset += 8;
        }
        wkbBuffer.putDouble(offset, env.xmin);
        wkbBuffer.putDouble(offset += 8, env.ymin);
        offset += 8;
        if (bExportZs) {
            wkbBuffer.putDouble(offset, z_interval.vmin);
            offset += 8;
        }
        if (bExportMs) {
            wkbBuffer.putDouble(offset, mInterval.vmin);
            offset += 8;
        }
        return offset;
    }
}

