/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

final class JSONUtils {
    JSONUtils() {
    }

    static boolean isObjectStart(JsonParser parser) throws Exception {
        return parser.getCurrentToken() == null ? parser.nextToken() == JsonToken.START_OBJECT : parser.getCurrentToken() == JsonToken.START_OBJECT;
    }

    static double readDouble(JsonParser parser) throws JsonParseException, IOException, Exception {
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return parser.getDoubleValue();
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return parser.getIntValue();
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return NumberUtils.NaN();
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_STRING && parser.getText().equals("NaN")) {
            return NumberUtils.NaN();
        }
        throw new GeometryException("invalid parameter");
    }
}

