/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;

public final class Envelope2D {
    private final int XLESSXMIN = 1;
    private final int YLESSYMIN = 4;
    private final int XMASK = 3;
    private final int YMASK = 12;
    double xmin;
    double ymin;
    double xmax;
    double ymax;

    public static Envelope2D construct(double _xmin, double _ymin, double _xmax, double _ymax) {
        Envelope2D env = new Envelope2D();
        env.xmin = _xmin;
        env.ymin = _ymin;
        env.xmax = _xmax;
        env.ymax = _ymax;
        return env;
    }

    public Envelope2D() {
        this.setEmpty();
    }

    public Envelope2D(double _xmin, double _ymin, double _xmax, double _ymax) {
        this.xmin = _xmin;
        this.ymin = _ymin;
        this.xmax = _xmax;
        this.ymax = _ymax;
    }

    public void setCoords(double _x, double _y) {
        this.xmin = _x;
        this.ymin = _y;
        this.xmax = _x;
        this.ymax = _y;
    }

    public void setCoords(double _xmin, double _ymin, double _xmax, double _ymax) {
        this.xmin = _xmin;
        this.ymin = _ymin;
        this.xmax = _xmax;
        this.ymax = _ymax;
        this.normalize();
    }

    public void setCoords(Point2D center, double width, double height) {
        this.xmin = center.x - width * 0.5;
        this.xmax = this.xmin + width;
        this.ymin = center.y - height * 0.5;
        this.ymax = this.ymin + height;
        this.normalize();
    }

    public void setCoords(Point2D pt) {
        this.xmin = pt.x;
        this.ymin = pt.y;
        this.xmax = pt.x;
        this.ymax = pt.y;
    }

    public void setCoords(Envelope2D envSrc) {
        this.setCoords(envSrc.xmin, envSrc.ymin, envSrc.xmax, envSrc.ymax);
    }

    public Envelope2D getInflated(double dx, double dy) {
        Envelope2D env = new Envelope2D();
        env.setCoords(this.xmin, this.ymin, this.xmax, this.ymax);
        env.inflate(dx, dy);
        return env;
    }

    public void setFromPoints(Point2D[] points) {
        if (points == null || points.length == 0) {
            this.setEmpty();
            return;
        }
        Point2D pt = points[0];
        this.setCoords(pt.x, pt.y);
        for (int i = 1; i < points.length; ++i) {
            Point2D pt2d = points[i];
            this.mergeNE(pt2d.x, pt2d.y);
        }
    }

    public void setEmpty() {
        this.xmin = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.ymax = Double.NaN;
    }

    public void setInfinite() {
        this.xmin = NumberUtils.negativeInf();
        this.xmax = NumberUtils.positiveInf();
        this.ymin = NumberUtils.negativeInf();
        this.ymax = NumberUtils.positiveInf();
    }

    public boolean isEmpty() {
        return NumberUtils.isNaN(this.xmin);
    }

    public void setCoords(Envelope1D xinterval, Envelope1D yinterval) {
        if (xinterval.isEmpty() || yinterval.isEmpty()) {
            this.setEmpty();
            return;
        }
        this.xmin = xinterval.vmin;
        this.xmax = xinterval.vmax;
        this.ymin = yinterval.vmin;
        this.ymax = yinterval.vmax;
    }

    public void merge(double x, double y) {
        if (this.isEmpty()) {
            this.xmin = x;
            this.ymin = y;
            this.xmax = x;
            this.ymax = y;
        } else {
            if (this.xmin > x) {
                this.xmin = x;
            } else if (this.xmax < x) {
                this.xmax = x;
            }
            if (this.ymin > y) {
                this.ymin = y;
            } else if (this.ymax < y) {
                this.ymax = y;
            }
        }
    }

    public void mergeNE(double x, double y) {
        if (this.xmin > x) {
            this.xmin = x;
        } else if (this.xmax < x) {
            this.xmax = x;
        }
        if (this.ymin > y) {
            this.ymin = y;
        } else if (this.ymax < y) {
            this.ymax = y;
        }
    }

    public void merge(Point2D pt) {
        this.merge(pt.x, pt.y);
    }

    public void merge(Point3D pt) {
        this.merge(pt.x, pt.y);
    }

    public void merge(Envelope2D other) {
        if (other.isEmpty()) {
            return;
        }
        this.merge(other.xmin, other.ymin);
        this.merge(other.xmax, other.ymax);
    }

    public void inflate(double dx, double dy) {
        if (this.isEmpty()) {
            return;
        }
        this.xmin -= dx;
        this.xmax += dx;
        this.ymin -= dy;
        this.ymax += dy;
        if (this.xmin > this.xmax || this.ymin > this.ymax) {
            this.setEmpty();
        }
    }

    public void scale(double f) {
        if (f < 0.0) {
            this.setEmpty();
        }
        if (this.isEmpty()) {
            return;
        }
        this.xmin *= f;
        this.xmax *= f;
        this.ymin *= f;
        this.ymax *= f;
    }

    public void zoom(double factorX, double factorY) {
        if (!this.isEmpty()) {
            this.setCoords(this.getCenter(), factorX * this.getWidth(), factorY * this.getHeight());
        }
    }

    public boolean isIntersecting(Envelope2D other) {
        return !this.isEmpty() && !other.isEmpty() && (this.xmin <= other.xmin ? this.xmax >= other.xmin : other.xmax >= this.xmin) && (this.ymin <= other.ymin ? this.ymax >= other.ymin : other.ymax >= this.ymin);
    }

    public boolean isIntersectingNE(Envelope2D other) {
        return (this.xmin <= other.xmin ? this.xmax >= other.xmin : other.xmax >= this.xmin) && (this.ymin <= other.ymin ? this.ymax >= other.ymin : other.ymax >= this.ymin);
    }

    public boolean intersect(Envelope2D other) {
        boolean bIntersecting;
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        if (other.xmin > this.xmin) {
            this.xmin = other.xmin;
        }
        if (other.xmax < this.xmax) {
            this.xmax = other.xmax;
        }
        if (other.ymin > this.ymin) {
            this.ymin = other.ymin;
        }
        if (other.ymax < this.ymax) {
            this.ymax = other.ymax;
        }
        boolean bl = bIntersecting = this.xmin <= this.xmax && this.ymin <= this.ymax;
        if (!bIntersecting) {
            this.setEmpty();
        }
        return bIntersecting;
    }

    public Point2D queryCorner(int index) {
        switch (index) {
            case 0: {
                return Point2D.construct(this.xmin, this.ymin);
            }
            case 1: {
                return Point2D.construct(this.xmin, this.ymax);
            }
            case 2: {
                return Point2D.construct(this.xmax, this.ymax);
            }
            case 3: {
                return Point2D.construct(this.xmax, this.ymin);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void queryCorners(Point2D[] corners) {
        if (corners == null || corners.length < 4) {
            throw new IllegalArgumentException();
        }
        corners[0] = new Point2D(this.xmin, this.ymin);
        corners[1] = new Point2D(this.xmin, this.ymax);
        corners[2] = new Point2D(this.xmax, this.ymax);
        corners[3] = new Point2D(this.xmax, this.ymin);
    }

    public void queryCornersReversed(Point2D[] corners) {
        if (corners == null || corners != null && corners.length < 4) {
            throw new IllegalArgumentException();
        }
        corners[0] = new Point2D(this.xmin, this.ymin);
        corners[1] = new Point2D(this.xmax, this.ymin);
        corners[2] = new Point2D(this.xmax, this.ymax);
        corners[3] = new Point2D(this.xmin, this.ymax);
    }

    public double getArea() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.getWidth() * this.getHeight();
    }

    public double getLength() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return 2.0 * (this.getWidth() + this.getHeight());
    }

    public void setFromPoints(Point2D[] points, int count) {
        if (count == 0) {
            this.setEmpty();
            return;
        }
        this.xmin = points[0].x;
        this.ymin = points[0].y;
        this.xmax = this.xmin;
        this.ymax = this.ymin;
        for (int i = 1; i < count; ++i) {
            Point2D pt = points[i];
            if (pt.x < this.xmin) {
                this.xmin = pt.x;
            } else if (pt.x > this.xmax) {
                this.xmax = pt.x;
            }
            if (pt.y < this.ymin) {
                this.ymin = pt.y;
                continue;
            }
            if (!(pt.y > this.ymax)) continue;
            this.ymax = pt.y;
        }
    }

    public void reaspect(double arWidth, double arHeight) {
        double heightHalf;
        double newWidthHalf;
        if (this.isEmpty()) {
            return;
        }
        double newAspectRatio = arWidth / arHeight;
        double widthHalf = this.getWidth() * 0.5;
        if (widthHalf <= (newWidthHalf = (heightHalf = this.getHeight() * 0.5) * newAspectRatio)) {
            double xc = this.getCenterX();
            this.xmin = xc - newWidthHalf;
            this.xmax = xc + newWidthHalf;
        } else {
            double newHeightHalf = widthHalf / newAspectRatio;
            double yc = this.getCenterY();
            this.ymin = yc - newHeightHalf;
            this.ymax = yc + newHeightHalf;
        }
        this.normalize();
    }

    public double getCenterX() {
        double cx = (this.xmax + this.xmin) / 2.0;
        return cx;
    }

    public double getCenterY() {
        double cy = (this.ymax + this.ymin) / 2.0;
        return cy;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public void move(double dx, double dy) {
        if (this.isEmpty()) {
            return;
        }
        this.xmin += dx;
        this.ymin += dy;
        this.xmax += dx;
        this.ymax += dy;
    }

    public void centerAt(double x, double y) {
        this.move(x - this.getCenterX(), y - this.getCenterY());
    }

    void centerAt(Point2D pt) {
        this.centerAt(pt.x, pt.y);
    }

    public void offset(double dx, double dy) {
        this.xmin += dx;
        this.xmax += dx;
        this.ymin += dy;
        this.ymax += dy;
    }

    public void normalize() {
        if (this.isEmpty()) {
            return;
        }
        double min = Math.min(this.xmin, this.xmax);
        double max = Math.max(this.xmin, this.xmax);
        this.xmin = min;
        this.xmax = max;
        min = Math.min(this.ymin, this.ymax);
        max = Math.max(this.ymin, this.ymax);
        this.ymin = min;
        this.ymax = max;
    }

    public void queryLowerLeft(Point2D pt) {
        pt.setCoords(this.xmin, this.ymin);
    }

    public void queryLowerRight(Point2D pt) {
        pt.setCoords(this.xmax, this.ymin);
    }

    public void queryUpperLeft(Point2D pt) {
        pt.setCoords(this.xmin, this.ymax);
    }

    public void queryUpperRight(Point2D pt) {
        pt.setCoords(this.xmax, this.ymax);
    }

    public boolean isValid() {
        return this.isEmpty() || this.xmin <= this.xmax && this.ymin <= this.ymax;
    }

    public Point2D getCenter() {
        return new Point2D((this.xmax + this.xmin) / 2.0, (this.ymax + this.ymin) / 2.0);
    }

    public void queryCenter(Point2D center) {
        center.x = (this.xmax + this.xmin) / 2.0;
        center.y = (this.ymax + this.ymin) / 2.0;
    }

    public void centerAt(Point c) {
        double cx = (this.xmax - this.xmin) / 2.0;
        double cy = (this.ymax - this.ymin) / 2.0;
        this.xmin = c.getX() - cx;
        this.xmax = c.getX() + cx;
        this.ymin = c.getY() - cy;
        this.ymax = c.getY() + cy;
    }

    public Point getLowerLeft() {
        return new Point(this.xmin, this.ymin);
    }

    public Point getUpperLeft() {
        return new Point(this.xmin, this.ymax);
    }

    public Point getLowerRight() {
        return new Point(this.xmax, this.ymin);
    }

    public Point getUpperRight() {
        return new Point(this.xmax, this.ymax);
    }

    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(double x, double y) {
        return !this.isEmpty() && x >= this.xmin && x <= this.xmax && y >= this.ymin && y <= this.ymax;
    }

    public boolean contains(Envelope2D other) {
        return other.xmin >= this.xmin && other.xmax <= this.xmax && other.ymin >= this.ymin && other.ymax <= this.ymax;
    }

    boolean containsExclusive(double x, double y) {
        return x > this.xmin && x < this.xmax && y > this.ymin && y < this.ymax;
    }

    boolean containsExclusive(Point2D pt) {
        return this.contains(pt.x, pt.y);
    }

    boolean containsExclusive(Envelope2D other) {
        return other.xmin > this.xmin && other.xmax < this.xmax && other.ymin > this.ymin && other.ymax < this.ymax;
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Envelope2D)) {
            return false;
        }
        Envelope2D other = (Envelope2D)_other;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return this.xmin == other.xmin && this.ymin == other.ymin && this.xmax == other.xmax && this.ymax == other.ymax;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.xmin);
        int hc = (int)(bits ^ bits >>> 32);
        int hash = NumberUtils.hash(hc);
        bits = Double.doubleToLongBits(this.xmax);
        hc = (int)(bits ^ bits >>> 32);
        hash = NumberUtils.hash(hash, hc);
        bits = Double.doubleToLongBits(this.ymin);
        hc = (int)(bits ^ bits >>> 32);
        hash = NumberUtils.hash(hash, hc);
        bits = Double.doubleToLongBits(this.ymax);
        hc = (int)(bits ^ bits >>> 32);
        hash = NumberUtils.hash(hash, hc);
        return hash;
    }

    Point2D _snapToBoundary(Point2D pt) {
        double deltay;
        Point2D p = new Point2D();
        p.setCoords(pt);
        if (p._isNan()) {
            return p;
        }
        if (this.isEmpty()) {
            p._setNan();
            return p;
        }
        if (p.x < this.xmin) {
            p.x = this.xmin;
        } else if (p.x > this.xmax) {
            p.x = this.xmax;
        }
        if (p.y < this.ymin) {
            p.y = this.ymin;
        } else if (p.y > this.ymax) {
            p.y = this.ymax;
        }
        if (!p.equals(pt)) {
            return p;
        }
        Point2D center = this.getCenter();
        double deltax = p.x < center.x ? p.x - this.xmin : this.xmax - p.x;
        double d = deltay = p.y < center.y ? p.y - this.ymin : this.ymax - p.y;
        if (deltax < deltay) {
            p.x = p.x < center.x ? this.xmin : this.xmax;
        } else {
            p.y = p.y < center.y ? this.ymin : this.ymax;
        }
        return p;
    }

    double _boundaryDistance(Point2D pt) {
        if (this.isEmpty()) {
            return NumberUtils.NaN();
        }
        if (pt.x == this.xmin) {
            return pt.y - this.ymin;
        }
        double height = this.ymax - this.ymin;
        double width = this.xmax - this.xmin;
        if (pt.y == this.ymax) {
            return height + pt.x - this.xmin;
        }
        if (pt.x == this.xmax) {
            return height + width + this.ymax - pt.y;
        }
        if (pt.y == this.ymin) {
            return height * 2.0 + width + this.xmax - pt.x;
        }
        return this._boundaryDistance(this._snapToBoundary(pt));
    }

    int _envelopeSide(Point2D pt) {
        double d;
        if (this.isEmpty()) {
            return -1;
        }
        double boundaryDist = this._boundaryDistance(pt);
        double height = this.ymax - this.ymin;
        double width = this.xmax - this.xmin;
        if (boundaryDist < height) {
            return 0;
        }
        boundaryDist -= height;
        if (d < width) {
            return 1;
        }
        return boundaryDist - width < height ? 2 : 3;
    }

    double _calculateToleranceFromEnvelope() {
        if (this.isEmpty()) {
            return NumberUtils.doubleEps() * 100.0;
        }
        double r = Math.abs(this.xmin) + Math.abs(this.xmax) + Math.abs(this.ymin) + Math.abs(this.ymax) + 1.0;
        return r * NumberUtils.doubleEps() * 100.0;
    }

    public int clipLine(Point2D p1, Point2D p2) {
        int c2;
        int c1 = this._clipCode(p1);
        if ((c1 & (c2 = this._clipCode(p2))) != 0) {
            return 0;
        }
        if ((c1 | c2) == 0) {
            return 4;
        }
        int res = (c1 != 0 ? 1 : 0) | (c2 != 0 ? 2 : 0);
        do {
            double dy;
            double dx;
            boolean bDX;
            boolean bl = bDX = (dx = p2.x - p1.x) > (dy = p2.y - p1.y);
            if (bDX) {
                if ((c1 & 3) != 0) {
                    if ((c1 & 1) != 0) {
                        p1.y += dy * (this.xmin - p1.x) / dx;
                        p1.x = this.xmin;
                    } else {
                        p1.y += dy * (this.xmax - p1.x) / dx;
                        p1.x = this.xmax;
                    }
                    c1 = this._clipCode(p1);
                } else if ((c2 & 3) != 0) {
                    if ((c2 & 1) != 0) {
                        p2.y += dy * (this.xmin - p2.x) / dx;
                        p2.x = this.xmin;
                    } else {
                        p2.y += dy * (this.xmax - p2.x) / dx;
                        p2.x = this.xmax;
                    }
                    c2 = this._clipCode(p2);
                } else if (c1 != 0) {
                    if ((c1 & 4) != 0) {
                        p1.x += dx * (this.ymin - p1.y) / dy;
                        p1.y = this.ymin;
                    } else {
                        p1.x += dx * (this.ymax - p1.y) / dy;
                        p1.y = this.ymax;
                    }
                    c1 = this._clipCode(p1);
                } else {
                    if ((c2 & 4) != 0) {
                        p2.x += dx * (this.ymin - p2.y) / dy;
                        p2.y = this.ymin;
                    } else {
                        p2.x += dx * (this.ymax - p2.y) / dy;
                        p2.y = this.ymax;
                    }
                    c2 = this._clipCode(p2);
                }
            } else if ((c1 & 0xC) != 0) {
                if ((c1 & 4) != 0) {
                    p1.x += dx * (this.ymin - p1.y) / dy;
                    p1.y = this.ymin;
                } else {
                    p1.x += dx * (this.ymax - p1.y) / dy;
                    p1.y = this.ymax;
                }
                c1 = this._clipCode(p1);
            } else if ((c2 & 0xC) != 0) {
                if ((c2 & 4) != 0) {
                    p2.x += dx * (this.ymin - p2.y) / dy;
                    p2.y = this.ymin;
                } else {
                    p2.x += dx * (this.ymax - p2.y) / dy;
                    p2.y = this.ymax;
                }
                c2 = this._clipCode(p2);
            } else if (c1 != 0) {
                if ((c1 & 1) != 0) {
                    p1.y += dy * (this.xmin - p1.x) / dx;
                    p1.x = this.xmin;
                } else {
                    p1.y += dy * (this.xmax - p1.x) / dx;
                    p1.x = this.xmax;
                }
                c1 = this._clipCode(p1);
            } else {
                if ((c2 & 1) != 0) {
                    p2.y += dy * (this.xmin - p2.x) / dx;
                    p2.x = this.xmin;
                } else {
                    p2.y += dy * (this.xmax - p2.x) / dx;
                    p2.x = this.xmax;
                }
                c2 = this._clipCode(p2);
            }
            if ((c1 & c2) == 0) continue;
            return 0;
        } while ((c1 | c2) != 0);
        return res;
    }

    int _clipCode(Point2D p) {
        int left = p.x < this.xmin ? 1 : 0;
        int right = p.x > this.xmax ? 1 : 0;
        int bottom = p.y < this.ymin ? 1 : 0;
        int top = p.y > this.ymax ? 1 : 0;
        return left | right << 1 | bottom << 2 | top << 3;
    }

    int clipLine(Point2D p0, Point2D p1, int lineExtension, double[] segParams, double[] boundaryDistances) {
        if (boundaryDistances != null) {
            boundaryDistances[0] = -1.0;
            boundaryDistances[1] = -1.0;
        }
        double[] tOld = new double[2];
        int modified = 0;
        Point2D delta = new Point2D(p1.x - p0.x, p1.y - p0.y);
        if (delta.x == 0.0 && delta.y == 0.0) {
            segParams[0] = 0.0;
            segParams[1] = 0.0;
            return this.contains(p0) ? 4 : 0;
        }
        segParams[0] = (lineExtension & 1) != 0 ? NumberUtils.negativeInf() : 0.0;
        segParams[1] = (lineExtension & 2) != 0 ? NumberUtils.positiveInf() : 1.0;
        tOld[0] = segParams[0];
        tOld[1] = segParams[1];
        if (this.clipLineAuxiliary(delta.x, this.xmin - p0.x, segParams) && this.clipLineAuxiliary(-delta.x, p0.x - this.xmax, segParams) && this.clipLineAuxiliary(delta.y, this.ymin - p0.y, segParams) && this.clipLineAuxiliary(-delta.y, p0.y - this.ymax, segParams)) {
            if (segParams[1] < tOld[1]) {
                p1.scaleAdd(segParams[1], delta, p0);
                this._snapToBoundary(p1);
                modified |= 2;
                if (boundaryDistances != null) {
                    boundaryDistances[1] = this._boundaryDistance(p1);
                }
            }
            if (segParams[0] > tOld[0]) {
                p0.scaleAdd(segParams[0], delta, p0);
                this._snapToBoundary(p0);
                modified |= 1;
                if (boundaryDistances != null) {
                    boundaryDistances[0] = this._boundaryDistance(p0);
                }
            }
        }
        return modified;
    }

    boolean clipLineAuxiliary(double denominator, double numerator, double[] segParams) {
        double t = numerator / denominator;
        if (denominator > 0.0) {
            if (t > segParams[1]) {
                return false;
            }
            if (t > segParams[0]) {
                segParams[0] = t;
                return true;
            }
        } else if (denominator < 0.0) {
            if (t < segParams[0]) {
                return false;
            }
            if (t < segParams[1]) {
                segParams[1] = t;
                return true;
            }
        } else {
            return numerator <= 0.0;
        }
        return true;
    }

    boolean isDegenerate(double tolerance) {
        return !this.isEmpty() && (this.getWidth() <= tolerance || this.getHeight() <= tolerance);
    }

    Point2D _snapClip(Point2D pt) {
        double x = NumberUtils.snap(pt.x, this.xmin, this.xmax);
        double y = NumberUtils.snap(pt.y, this.ymin, this.ymax);
        return new Point2D(x, y);
    }

    boolean isPointOnBoundary(Point2D pt, double tolerance) {
        return Math.abs(pt.x - this.xmin) <= tolerance || Math.abs(pt.x - this.xmax) <= tolerance || Math.abs(pt.y - this.ymin) <= tolerance || Math.abs(pt.y - this.ymax) <= tolerance;
    }

    double distance(Envelope2D other) {
        return Math.sqrt(this.sqrDistance(other));
    }

    double distance(Point2D pt2D) {
        return Math.sqrt(this.sqrDistance(pt2D));
    }

    double sqrDistance(Envelope2D other) {
        double dx = 0.0;
        double dy = 0.0;
        double nn = this.xmin - other.xmax;
        if (nn > dx) {
            dx = nn;
        }
        if ((nn = this.ymin - other.ymax) > dy) {
            dy = nn;
        }
        if ((nn = other.xmin - this.xmax) > dx) {
            dx = nn;
        }
        if ((nn = other.ymin - this.ymax) > dy) {
            dy = nn;
        }
        return dx * dx + dy * dy;
    }

    double sqrDistance(Point2D pt2D) {
        double dx = 0.0;
        double dy = 0.0;
        double nn = this.xmin - pt2D.x;
        if (nn > dx) {
            dx = nn;
        }
        if ((nn = this.ymin - pt2D.y) > dy) {
            dy = nn;
        }
        if ((nn = pt2D.x - this.xmax) > dx) {
            dx = nn;
        }
        if ((nn = pt2D.y - this.ymax) > dy) {
            dy = nn;
        }
        return dx * dx + dy * dy;
    }

    void queryIntervalX(Envelope1D env1D) {
        if (this.isEmpty()) {
            env1D.setEmpty();
        } else {
            env1D.setCoords(this.xmin, this.xmax);
        }
    }

    void queryIntervalY(Envelope1D env1D) {
        if (this.isEmpty()) {
            env1D.setEmpty();
        } else {
            env1D.setCoords(this.ymin, this.ymax);
        }
    }
}

