/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class VersionFieldSerializer<T>
extends FieldSerializer<T> {
    private final VersionFieldSerializerConfig config;
    private int typeVersion;
    private int[] fieldVersion;

    public VersionFieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new VersionFieldSerializerConfig());
    }

    public VersionFieldSerializer(Kryo kryo, Class type, VersionFieldSerializerConfig config) {
        super(kryo, type, config);
        this.config = config;
        this.setAcceptsNull(true);
        this.initializeCachedFields();
    }

    @Override
    protected void initializeCachedFields() {
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        this.fieldVersion = new int[fields.length];
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Field field = fields[i].field;
            Since since = field.getAnnotation(Since.class);
            if (since != null) {
                this.fieldVersion[i] = since.value();
                this.typeVersion = Math.max(this.fieldVersion[i], this.typeVersion);
                continue;
            }
            this.fieldVersion[i] = 0;
        }
        if (Log.DEBUG) {
            Log.debug((String)("Version for type " + this.getType().getName() + " is " + this.typeVersion));
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        if (object == null) {
            output.writeByte((byte)0);
            return;
        }
        int pop = this.pushTypeVariables();
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        output.writeVarInt(this.typeVersion + 1, true);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (Log.TRACE) {
                this.log("Write", fields[i], output.position());
            }
            fields[i].write(output, object);
        }
        if (pop > 0) {
            this.popTypeVariables(pop);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        int version = input.readVarInt(true);
        if (version == 0) {
            return null;
        }
        if (!this.config.compatible && --version != this.typeVersion) {
            throw new KryoException("Version is not compatible: " + version + " != " + this.typeVersion);
        }
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (this.fieldVersion[i] > version) {
                if (!Log.DEBUG) continue;
                Log.debug((String)("Skip field: " + fields[i].field.getName()));
                continue;
            }
            if (Log.TRACE) {
                this.log("Read", fields[i], input.position());
            }
            fields[i].read(input, object);
        }
        if (pop > 0) {
            this.popTypeVariables(pop);
        }
        return object;
    }

    public VersionFieldSerializerConfig getVersionFieldSerializerConfig() {
        return this.config;
    }

    public static class VersionFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        boolean compatible = true;

        @Override
        public VersionFieldSerializerConfig clone() {
            return (VersionFieldSerializerConfig)super.clone();
        }

        public void setCompatible(boolean compatible) {
            this.compatible = compatible;
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("VersionFieldSerializerConfig setCompatible: " + compatible));
            }
        }

        public boolean getCompatible() {
            return this.compatible;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Since {
        public int value() default 0;
    }
}

