/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks.io;

import com.esotericsoftware.kryo.benchmarks.io.InputOutputState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.SingleShotTime})
@Measurement(batchSize=12000000)
public class StringBenchmark {
    @Benchmark
    public void writeString(InputOutputState state) {
        state.reset();
        state.output.writeString("abc0123456789");
    }

    @Benchmark
    public String readString(ReadString state) {
        state.reset();
        return state.input.readString();
    }

    @Benchmark
    public void writeStringLong(InputOutputState state) {
        state.reset();
        state.output.writeString("abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789");
    }

    @Benchmark
    public String readStringLong(ReadStringLong state) {
        state.reset();
        return state.input.readString();
    }

    @Benchmark
    public void writeAsciiLong(InputOutputState state) {
        state.reset();
        state.output.writeAscii("abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789");
    }

    @Benchmark
    public String readAsciiLong(ReadAsciiLong state) {
        state.reset();
        return state.input.readString();
    }

    @State(value=Scope.Thread)
    public static class ReadAsciiLong
    extends InputOutputState {
        @Override
        public void setup() {
            super.setup();
            new StringBenchmark().writeAsciiLong(this);
        }
    }

    @State(value=Scope.Thread)
    public static class ReadStringLong
    extends InputOutputState {
        @Override
        public void setup() {
            super.setup();
            new StringBenchmark().writeStringLong(this);
        }
    }

    @State(value=Scope.Thread)
    public static class ReadString
    extends InputOutputState {
        @Override
        public void setup() {
            super.setup();
            new StringBenchmark().writeString(this);
        }
    }
}

