/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.benchmarks.data.Image;
import com.esotericsoftware.kryo.benchmarks.data.Media;
import com.esotericsoftware.kryo.benchmarks.data.MediaContent;
import com.esotericsoftware.kryo.benchmarks.data.Sample;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.VersionFieldSerializer;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class FieldSerializerBenchmark {
    @Benchmark
    public void field(FieldSerializerState state) {
        state.roundTrip();
    }

    @Benchmark
    public void compatible(CompatibleState state) {
        state.roundTrip();
    }

    @Benchmark
    public void tagged(TaggedState state) {
        state.roundTrip();
    }

    @Benchmark
    public void version(VersionState state) {
        state.roundTrip();
    }

    @Benchmark
    public void custom(CustomState state) {
        state.roundTrip();
    }

    static class ImageSerializer
    extends Serializer<Image> {
        private static final Image.Size[] sizes = Image.Size.values();

        ImageSerializer() {
        }

        public Image read(Kryo kryo, Input input, Class<? extends Image> type) {
            return new Image(input.readString(), input.readString(), input.readInt(true), input.readInt(true), sizes[input.readInt(true)], (Media)kryo.readObjectOrNull(input, Media.class));
        }

        public void write(Kryo kryo, Output output, Image image) {
            output.writeString(image.uri);
            output.writeString(image.title);
            output.writeInt(image.width, true);
            output.writeInt(image.height, true);
            output.writeInt(image.size.ordinal(), true);
            kryo.writeObjectOrNull(output, (Object)image.media, Media.class);
        }
    }

    static class MediaSerializer
    extends Serializer<Media> {
        private static final Media.Player[] players = Media.Player.values();
        private final CollectionSerializer personsSerializer = new CollectionSerializer();

        public MediaSerializer(Kryo kryo) {
            this.personsSerializer.setElementsCanBeNull(false);
            this.personsSerializer.setElementClass(String.class, kryo.getSerializer(String.class));
        }

        public Media read(Kryo kryo, Input input, Class<? extends Media> type) {
            return new Media(input.readString(), input.readString(), input.readInt(true), input.readInt(true), input.readString(), input.readLong(true), input.readLong(true), input.readInt(true), input.readBoolean(), (List)kryo.readObject(input, ArrayList.class, (Serializer)this.personsSerializer), players[input.readInt(true)], input.readString());
        }

        public void write(Kryo kryo, Output output, Media media) {
            output.writeString(media.uri);
            output.writeString(media.title);
            output.writeInt(media.width, true);
            output.writeInt(media.height, true);
            output.writeString(media.format);
            output.writeLong(media.duration, true);
            output.writeLong(media.size, true);
            output.writeInt(media.bitrate, true);
            output.writeBoolean(media.hasBitrate);
            kryo.writeObject(output, media.persons, (Serializer)this.personsSerializer);
            output.writeInt(media.player.ordinal(), true);
            output.writeString(media.copyright);
        }
    }

    static class MediaContentSerializer
    extends Serializer<MediaContent> {
        private final MediaSerializer mediaSerializer;
        private final CollectionSerializer imagesSerializer;

        public MediaContentSerializer(Kryo kryo, MediaSerializer mediaSerializer, ImageSerializer imageSerializer) {
            this.mediaSerializer = mediaSerializer;
            this.imagesSerializer = new CollectionSerializer();
            this.imagesSerializer.setElementsCanBeNull(false);
            this.imagesSerializer.setElementClass(Image.class, (Serializer)imageSerializer);
        }

        public MediaContent read(Kryo kryo, Input input, Class<? extends MediaContent> type) {
            return new MediaContent((Media)kryo.readObject(input, Media.class), (List)kryo.readObject(input, ArrayList.class, (Serializer)this.imagesSerializer));
        }

        public void write(Kryo kryo, Output output, MediaContent mediaContent) {
            kryo.writeObject(output, (Object)mediaContent.media, (Serializer)this.mediaSerializer);
            kryo.writeObject(output, mediaContent.images, (Serializer)this.imagesSerializer);
        }
    }

    public static class CustomState
    extends BenchmarkState {
        @Override
        public void setup() {
            super.setup();
            switch (this.objectType) {
                case sample: {
                    this.kryo.register(Sample.class, (Serializer)new Serializer<Sample>(){

                        public void write(Kryo kryo, Output output, Sample object) {
                            output.writeInt(object.intValue);
                            output.writeLong(object.longValue);
                            output.writeFloat(object.floatValue);
                            output.writeDouble(object.doubleValue);
                            output.writeShort((int)object.shortValue);
                            output.writeChar(object.charValue);
                            output.writeBoolean(object.booleanValue);
                            kryo.writeObject(output, (Object)object.IntValue);
                            kryo.writeObject(output, (Object)object.LongValue);
                            kryo.writeObject(output, (Object)object.FloatValue);
                            kryo.writeObject(output, (Object)object.DoubleValue);
                            kryo.writeObject(output, (Object)object.ShortValue);
                            kryo.writeObject(output, (Object)object.CharValue);
                            kryo.writeObject(output, (Object)object.BooleanValue);
                            kryo.writeObject(output, (Object)object.intArray);
                            kryo.writeObject(output, (Object)object.longArray);
                            kryo.writeObject(output, (Object)object.floatArray);
                            kryo.writeObject(output, (Object)object.doubleArray);
                            kryo.writeObject(output, (Object)object.shortArray);
                            kryo.writeObject(output, (Object)object.charArray);
                            kryo.writeObject(output, (Object)object.booleanArray);
                            kryo.writeObjectOrNull(output, (Object)object.string, String.class);
                            kryo.writeObjectOrNull(output, (Object)object.sample, Sample.class);
                        }

                        public Sample read(Kryo kryo, Input input, Class<? extends Sample> type) {
                            Sample object = new Sample();
                            object.intValue = input.readInt();
                            object.longValue = input.readLong();
                            object.floatValue = input.readFloat();
                            object.doubleValue = input.readDouble();
                            object.shortValue = input.readShort();
                            object.charValue = input.readChar();
                            object.booleanValue = input.readBoolean();
                            object.IntValue = (Integer)kryo.readObject(input, Integer.class);
                            object.LongValue = (Long)kryo.readObject(input, Long.class);
                            object.FloatValue = (Float)kryo.readObject(input, Float.class);
                            object.DoubleValue = (Double)kryo.readObject(input, Double.class);
                            object.ShortValue = (Short)kryo.readObject(input, Short.class);
                            object.CharValue = (Character)kryo.readObject(input, Character.class);
                            object.BooleanValue = (Boolean)kryo.readObject(input, Boolean.class);
                            object.intArray = (int[])kryo.readObject(input, int[].class);
                            object.longArray = (long[])kryo.readObject(input, long[].class);
                            object.floatArray = (float[])kryo.readObject(input, float[].class);
                            object.doubleArray = (double[])kryo.readObject(input, double[].class);
                            object.shortArray = (short[])kryo.readObject(input, short[].class);
                            object.charArray = (char[])kryo.readObject(input, char[].class);
                            object.booleanArray = (boolean[])kryo.readObject(input, boolean[].class);
                            object.string = (String)kryo.readObjectOrNull(input, String.class);
                            object.sample = (Sample)kryo.readObjectOrNull(input, Sample.class);
                            return object;
                        }
                    });
                    break;
                }
                case media: {
                    MediaSerializer mediaSerializer = new MediaSerializer(this.kryo);
                    ImageSerializer imageSerializer = new ImageSerializer();
                    this.kryo.register(Image.class, (Serializer)imageSerializer);
                    this.kryo.register(Media.class, (Serializer)mediaSerializer);
                    this.kryo.register(MediaContent.class, (Serializer)new MediaContentSerializer(this.kryo, mediaSerializer, imageSerializer));
                }
            }
        }
    }

    public static class VersionState
    extends BenchmarkState {
        @Override
        public void setup() {
            this.kryo.setDefaultSerializer(VersionFieldSerializer.class);
            super.setup();
        }
    }

    public static class TaggedState
    extends BenchmarkState {
        @Param(value={"true", "false"})
        public boolean chunked;

        @Override
        public void setup() {
            SerializerFactory.TaggedFieldSerializerFactory factory = new SerializerFactory.TaggedFieldSerializerFactory();
            factory.getConfig().setChunkedEncoding(this.chunked);
            if (this.chunked) {
                factory.getConfig().setReadUnknownTagData(true);
            }
            this.kryo.setDefaultSerializer((SerializerFactory)factory);
            super.setup();
        }
    }

    public static class CompatibleState
    extends BenchmarkState {
        @Param(value={"true", "false"})
        public boolean chunked;

        @Override
        public void setup() {
            SerializerFactory.CompatibleFieldSerializerFactory factory = new SerializerFactory.CompatibleFieldSerializerFactory();
            factory.getConfig().setChunkedEncoding(this.chunked);
            factory.getConfig().setReadUnknownFieldData(true);
            this.kryo.setDefaultSerializer((SerializerFactory)factory);
            super.setup();
        }
    }

    public static class FieldSerializerState
    extends BenchmarkState {
        @Override
        public void setup() {
            this.kryo.setDefaultSerializer(FieldSerializer.class);
            super.setup();
        }
    }

    @State(value=Scope.Thread)
    public static abstract class BenchmarkState {
        @Param(value={"true", "false"})
        public boolean references;
        @Param
        public ObjectType objectType;
        final Kryo kryo = new Kryo();
        final Output output = new Output(524288);
        final Input input = new Input(this.output.getBuffer());
        Object object;

        @Setup(value=Level.Trial)
        public void setup() {
            switch (this.objectType) {
                case sample: {
                    this.object = new Sample().populate(this.references);
                    this.kryo.register(double[].class);
                    this.kryo.register(int[].class);
                    this.kryo.register(long[].class);
                    this.kryo.register(float[].class);
                    this.kryo.register(double[].class);
                    this.kryo.register(short[].class);
                    this.kryo.register(char[].class);
                    this.kryo.register(boolean[].class);
                    this.kryo.register(this.object.getClass());
                    break;
                }
                case media: {
                    this.object = new MediaContent().populate(this.references);
                    this.kryo.register(Image.class);
                    this.kryo.register(Image.Size.class);
                    this.kryo.register(Media.class);
                    this.kryo.register(Media.Player.class);
                    this.kryo.register(ArrayList.class);
                    this.kryo.register(MediaContent.class);
                }
            }
            this.kryo.setReferences(this.references);
        }

        public void roundTrip() {
            this.output.setPosition(0);
            this.kryo.writeObject(this.output, this.object);
            this.input.setPosition(0);
            this.input.setLimit(this.output.position());
            this.kryo.readObject(this.input, this.object.getClass());
        }

        public static enum ObjectType {
            sample,
            media;

        }
    }
}

