/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks.io;

import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.unsafe.UnsafeByteBufferInput;
import com.esotericsoftware.kryo.unsafe.UnsafeByteBufferOutput;
import com.esotericsoftware.kryo.unsafe.UnsafeInput;
import com.esotericsoftware.kryo.unsafe.UnsafeOutput;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class InputOutputState {
    @Param
    public BufferType bufferType;
    Output output;
    Input input;

    @Setup(value=Level.Trial)
    public void setup() {
        switch (this.bufferType) {
            case array: {
                this.output = new Output(524288);
                this.input = new Input(this.output.getBuffer());
                break;
            }
            case unsafeArray: {
                this.output = new UnsafeOutput(524288);
                this.input = new UnsafeInput(this.output.getBuffer());
                break;
            }
            case byteBuffer: {
                this.output = new ByteBufferOutput(524288);
                this.input = new ByteBufferInput(((ByteBufferOutput)this.output).getByteBuffer());
                break;
            }
            case unsafeByteBuffer: {
                this.output = new UnsafeByteBufferOutput(524288);
                this.input = new UnsafeByteBufferInput(((UnsafeByteBufferOutput)this.output).getByteBuffer());
            }
        }
    }

    public void reset() {
        this.input.setPosition(0);
        this.output.setPosition(0);
    }

    public static enum BufferType {
        array,
        unsafeArray,
        byteBuffer,
        unsafeByteBuffer;

    }
}

