package com.eriwen.gradle.js.tasks

import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.SourceTask
import org.gradle.api.tasks.TaskAction

import java.util.zip.GZIPOutputStream

class GzipTask extends SourceTask {
    @OutputDirectory
    File dest

    void gzip(final File inputFile, final String targetFilePath) throws IOException {
        GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(targetFilePath))
        FileInputStream fis = new FileInputStream(inputFile)

        byte[] buf = new byte[1024]
        int len
        while ((len = fis.read(buf)) > 0) {
            gzos.write(buf, 0, len)
        }
        fis.close()
        gzos.finish()
        gzos.close()
    }

    @TaskAction
    def run() {
        source.visit { visitDetails ->
            if (visitDetails.isDirectory()) {
                visitDetails.relativePath.getFile(dest).mkdir()
            } else {
                String targetFilePath = "${visitDetails.relativePath.getFile(dest).absolutePath}.gz"
                gzip(visitDetails.file, targetFilePath)
            }
        }
    }
}