package com.eriwen.gradle.js.tasks

import org.apache.commons.codec.digest.DigestUtils
import org.gradle.api.file.FileVisitDetails
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.SourceTask
import org.gradle.api.tasks.TaskAction
import org.gradle.api.tasks.incremental.IncrementalTaskInputs

class DigestTask extends SourceTask {
    @OutputDirectory
    File dest

    File checksumFile(final File sourceFile, final String algorithm) {
        project.file("${sourceFile.absolutePath}.${algorithm}")
    }

    File digestedFile(final File file, final String digest) {
        project.file("${file.parent}${File.separator}${digest}-${file.name}")
    }

    void digest(final FileVisitDetails visitDetails) {
        // TODO: variable digest algorithm
        String checksum = DigestUtils.md5Hex(visitDetails.file.text)

        File targetFile = digestedFile(visitDetails.relativePath.getFile(dest), checksum)
        visitDetails.copyTo(targetFile)
        checksumFile(visitDetails.relativePath.getFile(dest), 'md5').text = checksum
    }

    def execute(IncrementalTaskInputs inputs) {
        if (!inputs.incremental) {
            project.delete(outputDir.listFiles())
        }

        inputs.outOfDate { change ->
            // delete checksum file
            // delete digested file
            // re-digest
        }

        inputs.removed {
            // delete checksum file
            // delete digested file
        }
    }

    @TaskAction
    def run() {
        source.visit { visitDetails ->
            if (visitDetails.isDirectory()) {
                visitDetails.relativePath.getFile(dest).mkdir()
            } else {
                digest(visitDetails)
            }
        }
    }
}
