/*
 * Decompiled with CFR 0.152.
 */
package com.eriwen.gradle.css.source.internal;

import com.eriwen.gradle.css.source.CssProcessingChain;
import com.eriwen.gradle.css.source.CssSourceSet;
import com.eriwen.gradle.css.source.internal.DefaultCssSourceSet;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.tasks.SourceTask;
import org.gradle.internal.reflect.Instantiator;

public class DefaultCssProcessingChain
extends DefaultNamedDomainObjectList<SourceTask>
implements CssProcessingChain {
    private final DefaultCssSourceSet source;
    private final Project project;

    public DefaultCssProcessingChain(Project project, DefaultCssSourceSet source, Instantiator instantiator) {
        super(SourceTask.class, instantiator, (Namer)new Task.Namer());
        this.source = source;
        this.project = project;
        this.wireChain();
    }

    @Override
    public CssSourceSet getSource() {
        return this.source;
    }

    protected void wireChain() {
        this.all((Action)new Action<SourceTask>(){

            public void execute(final SourceTask sourceTask) {
                sourceTask.source(new Object[]{new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        int index = DefaultCssProcessingChain.this.indexOf(sourceTask);
                        if (index == -1) {
                            return null;
                        }
                        if (index == 0) {
                            return DefaultCssProcessingChain.this.getSource().getCss();
                        }
                        SourceTask previous = (SourceTask)DefaultCssProcessingChain.this.get(index - 1);
                        return previous.getOutputs().getFiles();
                    }
                }});
            }
        });
    }

    @Override
    public <T extends SourceTask> T task(Class<T> type) {
        return this.task(this.calculateName(type), type);
    }

    @Override
    public <T extends SourceTask> T task(String name, Class<T> type) {
        return this.task(name, type, null);
    }

    @Override
    public <T extends SourceTask> T task(Class<T> type, Closure closure) {
        return this.task(this.calculateName(type), type, closure);
    }

    @Override
    public <T extends SourceTask> T task(String name, Class<T> type, Closure closure) {
        SourceTask task = (SourceTask)this.project.task(Collections.singletonMap("type", type), name, closure);
        this.add(task);
        return (T)task;
    }

    protected String calculateName(Class<? extends SourceTask> type) {
        String name = type.getName();
        if (name.endsWith("Task")) {
            name = name.substring(0, name.length() - 4);
        }
        return this.source.getName() + name;
    }
}

