/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class FilterCriteriaResolver
implements HandlerMethodArgumentResolver {
    public static final String DEFAULT_FILTER_PREFIX = "filter.";
    public static final String NOT_FILTER_MARKER = "!";

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(Filter.class) && null != methodParameter.getParameterAnnotation(FilterFor.class);
    }

    public Filter resolveArgument(MethodParameter methodParameter, ModelAndViewContainer paramModelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory paramWebDataBinderFactory) {
        return this.resolveAsList(methodParameter, webRequest);
    }

    private <T> Filter resolveAsList(MethodParameter methodParameter, NativeWebRequest webRequest) {
        Class<?> domainModelType = ((FilterFor)methodParameter.getParameterAnnotation(FilterFor.class)).value();
        List filterConditions = webRequest.getParameterMap().entrySet().stream().filter(parameter -> ((String)parameter.getKey()).startsWith(DEFAULT_FILTER_PREFIX) && ((String[])parameter.getValue()).length > 0).map(parameter -> {
            String[] tokens = ((String)parameter.getKey()).split("\\.");
            this.checkTokens(tokens);
            String stringCondition = tokens[1];
            boolean isNegative = stringCondition.startsWith(NOT_FILTER_MARKER);
            Condition condition = this.getCondition(isNegative ? StringUtils.substringAfter((String)stringCondition, (String)NOT_FILTER_MARKER) : stringCondition);
            String criteria = tokens[2];
            BusinessRule.expect((Object)((String[])parameter.getValue())[0], StringUtils::isNotBlank).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Filter criteria - '{}' value should be not empty", (Object[])new Object[]{parameter.getKey()}).get()});
            return new FilterCondition(condition, isNegative, ((String[])parameter.getValue())[0], criteria);
        }).collect(Collectors.toList());
        return new Filter(domainModelType, filterConditions);
    }

    private void checkTokens(String[] tokens) {
        BusinessRule.expect((Object)tokens.length, (Predicate)Predicates.equalTo((Object)3)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Incorrect format of filtering parameters"});
    }

    private Condition getCondition(String marker) {
        return (Condition)Condition.findByMarker((String)marker).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Unable to find condition with marker '" + marker + "'"}));
    }
}

