/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.handler.impl;

import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.dao.FilterableRepository;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.ws.handler.QueryHandler;
import com.epam.ta.reportportal.ws.rabbit.QueryRQ;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class QueryHandlerImpl
implements QueryHandler {
    private final ProjectRepository projectRepository;
    private final IntegrationRepository integrationRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private Map<String, FilterableRepository> repositories;

    public QueryHandlerImpl(ProjectRepository projectRepository, IntegrationRepository integrationRepository, TestItemRepository testItemRepository, LogRepository logRepository) {
        this.projectRepository = projectRepository;
        this.integrationRepository = integrationRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.repositories = ImmutableMap.builder().put((Object)Project.class.getSimpleName(), (Object)projectRepository).put((Object)Integration.class.getSimpleName(), (Object)integrationRepository).put((Object)TestItem.class.getSimpleName(), (Object)testItemRepository).put((Object)Log.class.getSimpleName(), (Object)logRepository).build();
    }

    @Override
    public Object find(QueryRQ queryRQ) {
        return Optional.ofNullable(this.repositories.get(queryRQ.getEntity())).map(repository -> repository.findByFilter((Queryable)queryRQ.getFilter())).orElseThrow(() -> new ReportPortalException("Repository not found"));
    }
}

