/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.utils.item.updater;

import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdater;
import com.epam.ta.reportportal.ws.reporting.TestItemResource;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RetriesUpdater
implements ResourceUpdater<TestItemResource> {
    private final Map<Long, List<TestItem>> retriesMapping;

    private RetriesUpdater(Map<Long, List<TestItem>> retriesMapping) {
        this.retriesMapping = retriesMapping;
    }

    @Override
    public void updateResource(TestItemResource resource) {
        Optional.ofNullable(this.retriesMapping.get(resource.getItemId())).ifPresent(retries -> resource.setRetries(retries.stream().map(TestItemConverter.TO_RESOURCE).collect(Collectors.toList())));
    }

    public static RetriesUpdater of(Map<Long, List<TestItem>> retriesMapping) {
        return new RetriesUpdater(retriesMapping);
    }
}

