/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.utils.item.provider;

import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdater;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdaterProvider;
import com.epam.ta.reportportal.ws.converter.utils.item.content.TestItemUpdaterContent;
import com.epam.ta.reportportal.ws.converter.utils.item.updater.RetriesUpdater;
import com.epam.ta.reportportal.ws.reporting.TestItemResource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetriesUpdaterProvider
implements ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource> {
    private final TestItemRepository testItemRepository;

    @Autowired
    public RetriesUpdaterProvider(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Override
    public ResourceUpdater<TestItemResource> retrieve(TestItemUpdaterContent updaterContent) {
        Map<Long, List<TestItem>> retriesMapping = this.testItemRepository.selectRetries(updaterContent.getTestItems().stream().filter(TestItem::isHasRetries).map(TestItem::getItemId).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(TestItem::getRetryOf));
        return RetriesUpdater.of(retriesMapping);
    }
}

