/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.resource.handler.attribute.launch;

import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.ResourceAttributeHandler;
import com.epam.ta.reportportal.ws.reporting.LaunchResource;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LaunchResourceMetadataAttributeUpdater
implements ResourceAttributeHandler<LaunchResource> {
    private final Set<String> supportedKeys;

    public LaunchResourceMetadataAttributeUpdater(Set<String> supportedKeys) {
        this.supportedKeys = supportedKeys;
    }

    @Override
    public void handle(LaunchResource resource, Collection<ItemAttribute> attributes) {
        attributes.forEach(it -> {
            if (StringUtils.isNotBlank((CharSequence)it.getKey()) && this.supportedKeys.contains(it.getKey())) {
                Optional.ofNullable(resource.getMetadata()).ifPresentOrElse(metadata -> this.updateMetadata((ItemAttribute)it, (Map<String, Object>)metadata), () -> {
                    HashMap metadata = Maps.newHashMapWithExpectedSize((int)this.supportedKeys.size());
                    this.updateMetadata((ItemAttribute)it, metadata);
                    resource.setMetadata((Map)metadata);
                });
            }
        });
    }

    private void updateMetadata(ItemAttribute it, Map<String, Object> metadata) {
        metadata.put(it.getKey(), it.getValue());
    }
}

