/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.reportportal.model.ActivityResource;
import com.epam.ta.reportportal.entity.activity.Activity;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ActivityConverter {
    public static final Function<Activity, ActivityResource> TO_RESOURCE = activity -> {
        ActivityResource resource = new ActivityResource();
        resource.setId(activity.getId());
        resource.setLastModified(activity.getCreatedAt());
        resource.setObjectType(activity.getObjectType().toString());
        resource.setActionType(activity.getEventName());
        resource.setProjectId(activity.getProjectId());
        resource.setUser(activity.getSubjectName());
        Optional.ofNullable(activity.getObjectId()).ifPresent(arg_0 -> ((ActivityResource)resource).setLoggedObjectId(arg_0));
        resource.setObjectName(activity.getObjectName());
        resource.setDetails((Object)activity.getDetails());
        return resource;
    };
    public static final BiFunction<Activity, String, ActivityResource> TO_RESOURCE_WITH_USER = (activity, username) -> {
        ActivityResource resource = TO_RESOURCE.apply((Activity)activity);
        resource.setUser(username);
        return resource;
    };

    private ActivityConverter() {
    }
}

