/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.model.widget.WidgetPreviewRQ;
import com.epam.ta.reportportal.model.widget.WidgetRQ;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class WidgetBuilder
implements Supplier<Widget> {
    private Widget widget;

    public WidgetBuilder() {
        this.widget = new Widget();
    }

    public WidgetBuilder(Widget widget) {
        this.widget = widget;
    }

    public WidgetBuilder addWidgetRq(WidgetRQ widgetRQ) {
        Optional.ofNullable(widgetRQ.getName()).ifPresent(name -> this.widget.setName(name));
        this.widget.setDescription(widgetRQ.getDescription());
        Optional.ofNullable(widgetRQ.getContentParameters()).ifPresent(cp -> {
            Optional.ofNullable(cp.getWidgetOptions()).ifPresent(wo -> {
                WidgetOptions widgetOptions = Optional.ofNullable(this.widget.getWidgetOptions()).orElseGet(WidgetOptions::new);
                Map options = Optional.ofNullable(widgetOptions.getOptions()).orElseGet(LinkedHashMap::new);
                options.putAll(wo);
                widgetOptions.setOptions(options);
                this.widget.setWidgetOptions(widgetOptions);
            });
            this.widget.setItemsCount(widgetRQ.getContentParameters().getItemsCount());
            this.widget.getContentFields().clear();
            this.widget.getContentFields().addAll(Optional.ofNullable(widgetRQ.getContentParameters().getContentFields()).orElse(Collections.emptyList()));
        });
        this.widget.setWidgetType(widgetRQ.getWidgetType());
        return this;
    }

    public WidgetBuilder addWidgetPreviewRq(WidgetPreviewRQ previewRQ) {
        WidgetOptions widgetOptions = Optional.ofNullable(this.widget.getWidgetOptions()).orElseGet(WidgetOptions::new);
        Map options = Optional.ofNullable(widgetOptions.getOptions()).orElseGet(LinkedHashMap::new);
        Optional.ofNullable(previewRQ.getContentParameters()).ifPresent(cp -> {
            options.putAll(cp.getWidgetOptions());
            this.widget.setItemsCount(cp.getItemsCount());
            this.widget.getContentFields().clear();
            this.widget.getContentFields().addAll(Optional.ofNullable(cp.getContentFields()).orElse(Collections.emptyList()));
        });
        widgetOptions.setOptions(options);
        this.widget.setWidgetOptions(widgetOptions);
        this.widget.setWidgetType(previewRQ.getWidgetType());
        return this;
    }

    public WidgetBuilder addProject(Long projectId) {
        Project project = new Project();
        project.setId(projectId);
        this.widget.setProject(project);
        return this;
    }

    public WidgetBuilder addFilters(Iterable<UserFilter> userFilters) {
        Optional.ofNullable(userFilters).ifPresent(it -> this.widget.setFilters((Set)Sets.newLinkedHashSet((Iterable)it)));
        return this;
    }

    public WidgetBuilder addOwner(String owner) {
        this.widget.setOwner(owner);
        return this;
    }

    public WidgetBuilder addOption(String key, Object value) {
        WidgetOptions widgetOptions = Optional.ofNullable(this.widget.getWidgetOptions()).orElseGet(() -> {
            WidgetOptions opts = new WidgetOptions();
            this.widget.setWidgetOptions(opts);
            return opts;
        });
        Map options = Optional.ofNullable(widgetOptions.getOptions()).orElseGet(() -> {
            LinkedHashMap opts = new LinkedHashMap();
            widgetOptions.setOptions(opts);
            return opts;
        });
        options.put(key, value);
        return this;
    }

    @Override
    public Widget get() {
        return this.widget;
    }
}

