/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.reporting.ItemAttributeResource;
import com.epam.ta.reportportal.ws.reporting.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.reporting.Mode;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LaunchBuilder
implements Supplier<Launch> {
    private static final int LAUNCH_DESCRIPTION_LENGTH_LIMIT = 2048;
    private static final int DESCRIPTION_START_SYMBOL_INDEX = 0;
    private Launch launch;

    public LaunchBuilder() {
        this.launch = new Launch();
    }

    public LaunchBuilder(Launch launch) {
        this.launch = launch;
    }

    public LaunchBuilder addStartRQ(StartLaunchRQ request) {
        Preconditions.checkNotNull((Object)request, (Object)ErrorType.BAD_REQUEST_ERROR);
        this.launch.setStartTime(request.getStartTime());
        this.launch.setName(request.getName().trim());
        this.launch.setStatus(StatusEnum.IN_PROGRESS);
        this.launch.setUuid(Optional.ofNullable(request.getUuid()).orElse(UUID.randomUUID().toString()));
        this.addDescription(request.getDescription());
        LaunchModeEnum.findByName((String)Optional.ofNullable(request.getMode()).map(Enum::name).orElse(LaunchModeEnum.DEFAULT.name())).ifPresent(it -> this.launch.setMode(it));
        return this;
    }

    public LaunchBuilder addDescription(String description) {
        Optional.ofNullable(description).ifPresent(it -> this.launch.setDescription(StringUtils.substring((String)it.trim(), (int)0, (int)2048)));
        return this;
    }

    public LaunchBuilder addUserId(Long userId) {
        this.launch.setUserId(userId);
        return this;
    }

    public LaunchBuilder addProject(Long projectId) {
        this.launch.setProjectId(projectId);
        return this;
    }

    public LaunchBuilder addAttribute(ItemAttributeResource attributeResource) {
        ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply(attributeResource);
        itemAttribute.setLaunch(this.launch);
        this.launch.getAttributes().add(itemAttribute);
        return this;
    }

    public LaunchBuilder addAttributes(Set<ItemAttributesRQ> attributes) {
        Optional.ofNullable(attributes).ifPresent(it -> this.launch.getAttributes().addAll(it.stream().map(val -> {
            ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply((ItemAttributeResource)val);
            itemAttribute.setLaunch(this.launch);
            return itemAttribute;
        }).collect(Collectors.toSet())));
        return this;
    }

    public LaunchBuilder overwriteAttributes(Set<ItemAttributeResource> attributes) {
        if (attributes != null) {
            Set overwrittenAttributes = this.launch.getAttributes().stream().filter(ItemAttribute::isSystem).collect(Collectors.toSet());
            attributes.stream().map(val -> {
                ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply((ItemAttributeResource)val);
                itemAttribute.setLaunch(this.launch);
                return itemAttribute;
            }).forEach(overwrittenAttributes::add);
            this.launch.setAttributes(overwrittenAttributes);
        }
        return this;
    }

    public LaunchBuilder addMode(Mode mode) {
        Optional.ofNullable(mode).ifPresent(it -> this.launch.setMode(LaunchModeEnum.valueOf((String)it.name())));
        return this;
    }

    public LaunchBuilder addStatus(String status) {
        this.launch.setStatus((StatusEnum)StatusEnum.fromValue((String)status).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FINISH_STATUS, new Object[0])));
        return this;
    }

    public LaunchBuilder addEndTime(Instant date) {
        this.launch.setEndTime(date);
        return this;
    }

    @Override
    public Launch get() {
        return this.launch;
    }
}

