/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.model.settings.AnalyticsResource;
import com.epam.ta.reportportal.model.settings.UpdateSettingsRq;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/settings"})
@PreAuthorize(value="hasRole('ADMINISTRATOR')")
@Tag(name="Settings", description="Settings API collection")
public class SettingsController {
    private final ServerAdminHandler serverHandler;

    @Autowired
    public SettingsController(ServerAdminHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    @Transactional
    @RequestMapping(value={"/analytics"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update analytics settings")
    public OperationCompletionRS saveAnalyticsSettings(@RequestBody @Validated AnalyticsResource request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.serverHandler.saveAnalyticsSettings(request);
    }

    @Transactional
    @PutMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update server settings with specified key")
    public OperationCompletionRS updateServerSettings(@RequestBody @Validated UpdateSettingsRq request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.serverHandler.updateServerSettings(request, user);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get server settings")
    public Map<String, String> getServerSettings(@AuthenticationPrincipal ReportPortalUser user) {
        return this.serverHandler.getServerSettings();
    }
}

