/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.core.project.settings.CreateProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.DeleteProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.GetProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.UpdateProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.notification.CreateProjectNotificationHandler;
import com.epam.ta.reportportal.core.project.settings.notification.DeleteProjectNotificationHandler;
import com.epam.ta.reportportal.core.project.settings.notification.GetProjectNotificationsHandler;
import com.epam.ta.reportportal.core.project.settings.notification.UpdateProjectNotificationHandler;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.project.config.CreateIssueSubTypeRQ;
import com.epam.ta.reportportal.model.project.config.IssueSubTypeCreatedRS;
import com.epam.ta.reportportal.model.project.config.ProjectSettingsResource;
import com.epam.ta.reportportal.model.project.config.UpdateIssueSubTypeRQ;
import com.epam.ta.reportportal.model.project.config.pattern.CreatePatternTemplateRQ;
import com.epam.ta.reportportal.model.project.config.pattern.UpdatePatternTemplateRQ;
import com.epam.ta.reportportal.model.project.email.SenderCaseDTO;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/settings"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@Tag(name="Project Settings", description="Project Settings API collection")
public class ProjectSettingsController {
    private final CreateProjectSettingsHandler createHandler;
    private final UpdateProjectSettingsHandler updateHandler;
    private final DeleteProjectSettingsHandler deleteHandler;
    private final GetProjectSettingsHandler getHandler;
    private final GetProjectHandler getProjectHandler;
    private final GetProjectNotificationsHandler getProjectNotificationsHandler;
    private final CreateProjectNotificationHandler createProjectNotificationHandler;
    private final UpdateProjectNotificationHandler updateProjectNotificationHandler;
    private final DeleteProjectNotificationHandler deleteNotificationHandler;

    @Autowired
    public ProjectSettingsController(CreateProjectSettingsHandler createHandler, UpdateProjectSettingsHandler updateHandler, DeleteProjectSettingsHandler deleteHandler, GetProjectSettingsHandler getHandler, GetProjectHandler getProjectHandler, GetProjectNotificationsHandler getProjectNotificationsHandler, CreateProjectNotificationHandler createProjectNotificationHandler, UpdateProjectNotificationHandler updateProjectNotificationHandler, DeleteProjectNotificationHandler deleteNotificationHandler) {
        this.createHandler = createHandler;
        this.updateHandler = updateHandler;
        this.deleteHandler = deleteHandler;
        this.getHandler = getHandler;
        this.getProjectHandler = getProjectHandler;
        this.getProjectNotificationsHandler = getProjectNotificationsHandler;
        this.createProjectNotificationHandler = createProjectNotificationHandler;
        this.updateProjectNotificationHandler = updateProjectNotificationHandler;
        this.deleteNotificationHandler = deleteNotificationHandler;
    }

    @PostMapping(value={"/sub-type"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Creation of custom project specific issue sub-type")
    public IssueSubTypeCreatedRS createProjectIssueSubType(@PathVariable String projectName, @RequestBody @Validated CreateIssueSubTypeRQ request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createHandler.createProjectIssueSubType(EntityUtils.normalizeId((String)projectName), user, request);
    }

    @PutMapping(value={"/sub-type"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Update of custom project specific issue sub-type")
    public OperationCompletionRS updateProjectIssueSubType(@PathVariable String projectName, @RequestBody @Validated UpdateIssueSubTypeRQ request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateHandler.updateProjectIssueSubType(EntityUtils.normalizeId((String)projectName), user, request);
    }

    @DeleteMapping(value={"/sub-type/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Delete custom project specific issue sub-type")
    public OperationCompletionRS deleteProjectIssueSubType(@PathVariable String projectName, @PathVariable Long id, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteHandler.deleteProjectIssueSubType(EntityUtils.normalizeId((String)projectName), user, id);
    }

    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Get project specific issue sub-types", description="Only for users that are assigned to the project")
    public ProjectSettingsResource getProjectSettings(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getHandler.getProjectSettings(EntityUtils.normalizeId((String)projectName));
    }

    @PostMapping(value={"/pattern"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Create pattern template for items' log messages pattern analysis")
    public EntryCreatedRS createPatternTemplate(@PathVariable String projectName, @RequestBody @Validated CreatePatternTemplateRQ createPatternTemplateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createHandler.createPatternTemplate(EntityUtils.normalizeId((String)projectName), createPatternTemplateRQ, user);
    }

    @PutMapping(value={"/pattern/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Update pattern template for items' log messages pattern analysis")
    public OperationCompletionRS updatePatternTemplate(@PathVariable String projectName, @PathVariable Long id, @RequestBody @Validated UpdatePatternTemplateRQ updatePatternTemplateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateHandler.updatePatternTemplate(id, EntityUtils.normalizeId((String)projectName), updatePatternTemplateRQ, user);
    }

    @DeleteMapping(value={"/pattern/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Delete pattern template for items' log messages pattern analysis")
    public OperationCompletionRS deletePatternTemplate(@PathVariable String projectName, @PathVariable Long id, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteHandler.deletePatternTemplate(EntityUtils.normalizeId((String)projectName), user, id);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/notification"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Returns notifications config of specified project", description="Only for users assigned to specified project")
    public List<SenderCaseDTO> getNotifications(@PathVariable String projectName) {
        return this.getProjectNotificationsHandler.getProjectNotifications(this.getProjectHandler.get(EntityUtils.normalizeId((String)projectName)).getId());
    }

    @Transactional
    @PostMapping(value={"/notification"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Creates notification for specified project", description="Only for users with PROJECT_MANAGER or ADMIN roles")
    public EntryCreatedRS createNotification(@PathVariable String projectName, @RequestBody @Validated SenderCaseDTO createNotificationRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createProjectNotificationHandler.createNotification(this.getProjectHandler.get(EntityUtils.normalizeId((String)projectName)), createNotificationRQ, user);
    }

    @Transactional
    @PutMapping(value={"/notification"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Updates notification for specified project", description="Only for users with PROJECT_MANAGER or ADMIN roles")
    public OperationCompletionRS updateNotification(@PathVariable String projectName, @RequestBody @Validated SenderCaseDTO updateNotificationRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectNotificationHandler.updateNotification(this.getProjectHandler.get(EntityUtils.normalizeId((String)projectName)), updateNotificationRQ, user);
    }

    @Transactional
    @DeleteMapping(value={"/notification/{notificationId:\\d+}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Deletes notification for specified project", description="Only for users with PROJECT_MANAGER or ADMIN roles")
    public OperationCompletionRS deleteNotification(@PathVariable String projectName, @PathVariable Long notificationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteNotificationHandler.deleteNotification(this.getProjectHandler.get(EntityUtils.normalizeId((String)projectName)), notificationId, user);
    }
}

