/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.preference.GetPreferenceHandler;
import com.epam.ta.reportportal.core.preference.UpdatePreferenceHandler;
import com.epam.ta.reportportal.core.project.CreateProjectHandler;
import com.epam.ta.reportportal.core.project.DeleteProjectHandler;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.core.project.GetProjectInfoHandler;
import com.epam.ta.reportportal.core.project.UpdateProjectHandler;
import com.epam.ta.reportportal.core.user.GetUserHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.model.DeleteBulkRS;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.preference.PreferenceResource;
import com.epam.ta.reportportal.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.model.project.CreateProjectRQ;
import com.epam.ta.reportportal.model.project.ProjectInfoResource;
import com.epam.ta.reportportal.model.project.ProjectResource;
import com.epam.ta.reportportal.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.model.user.SearchUserResource;
import com.epam.ta.reportportal.model.user.UserResource;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/project"})
@Tag(name="Project", description="Projects API collection")
public class ProjectController {
    private final ProjectExtractor projectExtractor;
    private final GetProjectHandler getProjectHandler;
    private final GetProjectInfoHandler projectInfoHandler;
    private final CreateProjectHandler createProjectHandler;
    private final UpdateProjectHandler updateProjectHandler;
    private final DeleteProjectHandler deleteProjectHandler;
    private final GetUserHandler getUserHandler;
    private final GetPreferenceHandler getPreference;
    private final UpdatePreferenceHandler updatePreference;
    private final GetJasperReportHandler<ProjectInfo> jasperReportHandler;

    @Autowired
    public ProjectController(ProjectExtractor projectExtractor, GetProjectHandler getProjectHandler, GetProjectInfoHandler projectInfoHandler, CreateProjectHandler createProjectHandler, UpdateProjectHandler updateProjectHandler, DeleteProjectHandler deleteProjectHandler, GetUserHandler getUserHandler, GetPreferenceHandler getPreference, UpdatePreferenceHandler updatePreference, @Qualifier(value="projectJasperReportHandler") GetJasperReportHandler<ProjectInfo> jasperReportHandler) {
        this.projectExtractor = projectExtractor;
        this.getProjectHandler = getProjectHandler;
        this.projectInfoHandler = projectInfoHandler;
        this.createProjectHandler = createProjectHandler;
        this.updateProjectHandler = updateProjectHandler;
        this.deleteProjectHandler = deleteProjectHandler;
        this.getUserHandler = getUserHandler;
        this.getPreference = getPreference;
        this.updatePreference = updatePreference;
        this.jasperReportHandler = jasperReportHandler;
    }

    @Transactional
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Create new project")
    public EntryCreatedRS createProject(@RequestBody @Validated CreateProjectRQ createProjectRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createProjectHandler.createProject(createProjectRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Update project")
    public OperationCompletionRS updateProject(@PathVariable String projectName, @RequestBody @Validated UpdateProjectRQ updateProjectRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.updateProject(EntityUtils.normalizeId((String)projectName), updateProjectRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/notification"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Update project notifications configuration")
    public OperationCompletionRS updateProjectNotificationConfig(@PathVariable String projectName, @RequestBody @Validated ProjectNotificationConfigDTO updateProjectNotificationConfigRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.updateProjectNotificationConfig(EntityUtils.normalizeId((String)projectName), user, updateProjectNotificationConfigRQ);
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Delete multiple projects", description="Could be deleted only by users with administrator role")
    public DeleteBulkRS deleteProject(@RequestParam(value="ids") List<Long> ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteProjectHandler.bulkDeleteProjects(ids, user);
    }

    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Delete project", description="Could be deleted only by users with administrator role")
    public OperationCompletionRS deleteProject(@PathVariable Long projectId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteProjectHandler.deleteProject(projectId, user);
    }

    @DeleteMapping(value={"/{projectName}/index"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Delete project index from ML")
    public OperationCompletionRS deleteProjectIndex(@PathVariable String projectName, Principal principal) {
        return this.deleteProjectHandler.deleteProjectIndex(EntityUtils.normalizeId((String)projectName), principal.getName());
    }

    @Transactional
    @PutMapping(value={"/{projectName}/index"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Starts reindex all project data in ML")
    public OperationCompletionRS indexProjectData(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.indexProjectData(EntityUtils.normalizeId((String)projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/users"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Get users assigned on current project")
    public Page<UserResource> getProjectUsers(@PathVariable String projectName, @FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getProjectUsers(EntityUtils.normalizeId((String)projectName), filter, pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Get information about project", description="Only for users that are assigned to the project")
    public ProjectResource getProject(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getResource(EntityUtils.normalizeId((String)projectName), user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/unassign"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Unassign users")
    public OperationCompletionRS unassignProjectUsers(@PathVariable String projectName, @RequestBody @Validated UnassignUsersRQ unassignUsersRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.unassignUsers(EntityUtils.normalizeId((String)projectName), unassignUsersRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/assign"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Assign users")
    public OperationCompletionRS assignProjectUsers(@PathVariable String projectName, @RequestBody @Validated AssignUsersRQ assignUsersRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.assignUsers(projectName, assignUsersRQ, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/assignable"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Load users which can be assigned to specified project", description="Only for users with project manager permissions")
    public Page<UserResource> getUsersForAssign(@FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getUserHandler.getUsers(filter, pageable, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/usernames"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')||hasRole('ADMINISTRATOR')")
    @Operation(summary="Load project users by filter", description="Only for users that are members of the project")
    public List<String> getProjectUsers(@PathVariable String projectName, @RequestParam(value="filter.cnt.users") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getUserNames(this.projectExtractor.extractProjectDetails(user, projectName), EntityUtils.normalizeId((String)value));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/usernames/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public Page<SearchUserResource> searchForUser(@PathVariable String projectName, @RequestParam(value="term") String term, Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getUserNames(term, user.getUserRole(), this.projectExtractor.extractProjectDetails(user, projectName), pageable);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/preference/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Edit logged-in user preferences", description="Only for logged-in user")
    public OperationCompletionRS addUserPreference(@PathVariable String projectName, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updatePreference.addPreference(this.projectExtractor.extractProjectDetails(user, projectName), user, filterId);
    }

    @Transactional
    @DeleteMapping(value={"/{projectName}/preference/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete logged-in user preferences", description="Only for logged-in user")
    public OperationCompletionRS removeUserPreference(@PathVariable String projectName, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updatePreference.removePreference(this.projectExtractor.extractProjectDetails(user, projectName), user, filterId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/preference", "/{projectName}/preference/"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Load logged-in user preferences", description="Only for logged-in user")
    public PreferenceResource getUserPreference(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getPreference.getPreference(this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<ProjectInfoResource> getAllProjectsInfo(@FilterFor(value=ProjectInfo.class) Filter filter, @FilterFor(value=ProjectInfo.class) Queryable predefinedFilter, @SortFor(value=ProjectInfo.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.projectInfoHandler.getAllProjectsInfo((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/export"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Exports information about all projects", description="Allowable only for users with administrator role")
    public void exportProjects(@Parameter(schema=@Schema(allowableValues={"csv"})) @RequestParam(value="view", required=false, defaultValue="csv") String view, @FilterFor(value=ProjectInfo.class) Filter filter, @FilterFor(value=ProjectInfo.class) Queryable predefinedFilter, @AuthenticationPrincipal ReportPortalUser user, HttpServletResponse response) {
        ReportFormat format = this.jasperReportHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"RP_PROJECTS_%s_Report.%s\"", format.name(), format.getValue()));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.getProjectHandler.exportProjects(format, (Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to write data to the response."});
        }
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @GetMapping(value={"/list/{projectName}"})
    @ResponseStatus(value=HttpStatus.OK)
    public ProjectInfoResource getProjectInfo(@PathVariable String projectName, @RequestParam(value="interval", required=false, defaultValue="3M") String interval, @AuthenticationPrincipal ReportPortalUser user) {
        return this.projectInfoHandler.getProjectInfo(projectName, interval);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @GetMapping(value={"/{projectName}/widget/{widgetCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, ?> getProjectWidget(@PathVariable String projectName, @RequestParam(value="interval", required=false, defaultValue="3M") String interval, @PathVariable String widgetCode, @AuthenticationPrincipal ReportPortalUser user) {
        return this.projectInfoHandler.getProjectInfoWidgetContent(projectName, interval, widgetCode);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    public Iterable<String> getAllProjectNames(@AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getAllProjectNames();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/names/search"})
    @ResponseStatus(value=HttpStatus.OK)
    public Iterable<String> searchProjectNames(@RequestParam(value="term") String term, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getAllProjectNamesByTerm(term);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"analyzer/status"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, Boolean> getAnalyzerIndexingStatus(@AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getAnalyzerIndexingStatus();
    }
}

