/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.integration.CreateIntegrationHandler;
import com.epam.ta.reportportal.core.integration.DeleteIntegrationHandler;
import com.epam.ta.reportportal.core.integration.ExecuteIntegrationHandler;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.integration.IntegrationRQ;
import com.epam.ta.reportportal.model.integration.IntegrationResource;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/integration"})
@Tag(name="Integration", description="Integrations API collection")
public class IntegrationController {
    private final ProjectExtractor projectExtractor;
    private final DeleteIntegrationHandler deleteIntegrationHandler;
    private final GetIntegrationHandler getIntegrationHandler;
    private final CreateIntegrationHandler createIntegrationHandler;
    private final ExecuteIntegrationHandler executeIntegrationHandler;

    @Autowired
    public IntegrationController(ProjectExtractor projectExtractor, DeleteIntegrationHandler deleteIntegrationHandler, GetIntegrationHandler getIntegrationHandler, CreateIntegrationHandler createIntegrationHandler, ExecuteIntegrationHandler executeIntegrationHandler) {
        this.projectExtractor = projectExtractor;
        this.deleteIntegrationHandler = deleteIntegrationHandler;
        this.getIntegrationHandler = getIntegrationHandler;
        this.createIntegrationHandler = createIntegrationHandler;
        this.executeIntegrationHandler = executeIntegrationHandler;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/global/all", "/global/all/"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get available global integrations")
    public List<IntegrationResource> getGlobalIntegrations(@AuthenticationPrincipal ReportPortalUser reportPortalUser) {
        return this.getIntegrationHandler.getGlobalIntegrations();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/global/all/{pluginName}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get available global integrations for plugin")
    public List<IntegrationResource> getGlobalIntegrations(@AuthenticationPrincipal ReportPortalUser reportPortalUser, @PathVariable String pluginName) {
        return this.getIntegrationHandler.getGlobalIntegrations(pluginName);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/project/{projectName}/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Get available project integrations")
    public List<IntegrationResource> getProjectIntegrations(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser reportPortalUser) {
        return this.getIntegrationHandler.getProjectIntegrations(EntityUtils.normalizeId((String)projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/project/{projectName}/all/{pluginName}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Get available project integrations for plugin")
    public List<IntegrationResource> getProjectIntegrations(@AuthenticationPrincipal ReportPortalUser reportPortalUser, @PathVariable String projectName, @PathVariable String pluginName) {
        return this.getIntegrationHandler.getProjectIntegrations(pluginName, EntityUtils.normalizeId((String)projectName));
    }

    @Transactional
    @PostMapping(value={"/{pluginName}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create global ReportPortal integration instance")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public EntryCreatedRS createGlobalIntegration(@RequestBody @Valid IntegrationRQ createRequest, @PathVariable String pluginName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createIntegrationHandler.createGlobalIntegration(createRequest, pluginName, user);
    }

    @Transactional
    @PostMapping(value={"/{projectName}/{pluginName}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create project ReportPortal integration instance")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedRS createProjectIntegration(@RequestBody @Valid IntegrationRQ createRequest, @PathVariable String pluginName, @PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createIntegrationHandler.createProjectIntegration(EntityUtils.normalizeId((String)projectName), createRequest, pluginName, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"{projectName}/{integrationId}/connection/test"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Test connection to the integration through the project config")
    public boolean testIntegrationConnection(@PathVariable Long integrationId, @PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getIntegrationHandler.testConnection(integrationId, EntityUtils.normalizeId((String)projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{integrationId}/connection/test"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Test connection to the global integration")
    public boolean testIntegrationConnection(@PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getIntegrationHandler.testConnection(integrationId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get global ReportPortal integration instance")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public IntegrationResource getGlobalIntegration(@PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getIntegrationHandler.getGlobalIntegrationById(integrationId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get integration instance")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    public IntegrationResource getProjectIntegration(@PathVariable String projectName, @PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getIntegrationHandler.getProjectIntegrationById(integrationId, EntityUtils.normalizeId((String)projectName));
    }

    @Transactional
    @PutMapping(value={"/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update global ReportPortal integration instance")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS updateGlobalIntegration(@PathVariable Long integrationId, @RequestBody @Valid IntegrationRQ updateRequest, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createIntegrationHandler.updateGlobalIntegration(integrationId, updateRequest, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update project integration instance")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public OperationCompletionRS updateProjectIntegration(@PathVariable Long integrationId, @RequestBody @Valid IntegrationRQ updateRequest, @PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createIntegrationHandler.updateProjectIntegration(integrationId, EntityUtils.normalizeId((String)projectName), updateRequest, user);
    }

    @Transactional
    @DeleteMapping(value={"/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete global integration instance")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS deleteGlobalIntegration(@PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteIntegrationHandler.deleteGlobalIntegration(integrationId, user);
    }

    @Transactional
    @DeleteMapping(value={"/all/{type}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete all global integrations by type")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS deleteAllIntegrations(@PathVariable String type, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteIntegrationHandler.deleteGlobalIntegrationsByType(type, user);
    }

    @Transactional
    @DeleteMapping(value={"/{projectName}/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete project integration instance")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public OperationCompletionRS deleteProjectIntegration(@PathVariable String projectName, @PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteIntegrationHandler.deleteProjectIntegration(integrationId, EntityUtils.normalizeId((String)projectName), user);
    }

    @Transactional
    @DeleteMapping(value={"/{projectName}/all/{type}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete all integrations assigned to specified project")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public OperationCompletionRS deleteAllProjectIntegrations(@PathVariable String type, @PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteIntegrationHandler.deleteProjectIntegrationsByType(type, EntityUtils.normalizeId((String)projectName), user);
    }

    @Transactional
    @PutMapping(value={"{projectName}/{integrationId}/{command}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Execute command to the integration instance")
    public Object executeIntegrationCommand(@PathVariable String projectName, @PathVariable(value="integrationId") Long integrationId, @PathVariable(value="command") String command, @RequestBody Map<String, Object> executionParams, @AuthenticationPrincipal ReportPortalUser user) {
        return this.executeIntegrationHandler.executeCommand(this.projectExtractor.extractProjectDetails(user, projectName), integrationId, command, executionParams);
    }
}

