/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.api.GroupsApi;
import com.epam.reportportal.api.model.AddProjectToGroupByIdRequest;
import com.epam.reportportal.api.model.CreateGroupRequest;
import com.epam.reportportal.api.model.GroupInfo;
import com.epam.reportportal.api.model.GroupPage;
import com.epam.reportportal.api.model.GroupProjectInfo;
import com.epam.reportportal.api.model.GroupProjectsPage;
import com.epam.reportportal.api.model.GroupUserInfo;
import com.epam.reportportal.api.model.GroupUsersPage;
import com.epam.reportportal.api.model.SuccessfulUpdate;
import com.epam.reportportal.api.model.UpdateGroupRequest;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.group.GroupExtensionPoint;
import org.pf4j.PluginManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class GroupController
implements GroupsApi {
    private final PluginManager pluginManager;

    @Autowired
    public GroupController(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupPage> getGroups(Integer offset, Integer limit, String order, String sort) {
        GroupPage groupPage = this.getGroupExtension().getGroups(offset, limit, order, sort);
        return ResponseEntity.ok((Object)groupPage);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupInfo> createGroup(CreateGroupRequest createGroupRequest) {
        GroupInfo group = this.getGroupExtension().createGroup(createGroupRequest, this.getPrincipal().getUserId());
        return new ResponseEntity((Object)group, (HttpStatusCode)HttpStatus.CREATED);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupInfo> getGroupById(Long groupId) {
        GroupInfo group = this.getGroupExtension().getGroupById(groupId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return ResponseEntity.ok((Object)group);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<SuccessfulUpdate> updateGroup(Long groupId, UpdateGroupRequest updateGroupRequest) {
        this.getGroupExtension().updateGroup(groupId, updateGroupRequest);
        return ResponseEntity.ok((Object)new SuccessfulUpdate("Group updated successfully"));
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<Void> deleteGroup(Long groupId) {
        this.getGroupExtension().deleteGroup(groupId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupUsersPage> getGroupUsers(Long groupId, Integer offset, Integer limit) {
        GroupUsersPage usersPage = this.getGroupExtension().getGroupUsers(groupId, offset, limit);
        return ResponseEntity.ok((Object)usersPage);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupUserInfo> getGroupUserById(Long groupId, Long userId) {
        GroupUserInfo groupUserInfo = this.getGroupExtension().getGroupUserById(groupId, userId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return ResponseEntity.ok((Object)groupUserInfo);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<SuccessfulUpdate> addUserToGroupById(Long groupId, Long userId) {
        this.getGroupExtension().addUserToGroupById(groupId, userId);
        return ResponseEntity.ok((Object)new SuccessfulUpdate("Group updated successfully"));
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<Void> deleteUserFromGroupById(Long groupId, Long userId) {
        this.getGroupExtension().deleteUserFromGroupById(groupId, userId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupProjectsPage> getGroupProjects(Long groupId, Integer offset, Integer limit) {
        GroupProjectsPage groupProjectsPage = this.getGroupExtension().getGroupProjects(groupId, offset, limit);
        return ResponseEntity.ok((Object)groupProjectsPage);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<GroupProjectInfo> getGroupProjectById(Long groupId, Long projectId) {
        GroupProjectInfo groupProjectInfo = this.getGroupExtension().getGroupProjectById(groupId, projectId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return ResponseEntity.ok((Object)groupProjectInfo);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<SuccessfulUpdate> addProjectToGroupById(Long groupId, Long projectId, AddProjectToGroupByIdRequest addProjectToGroupByIdRequest) {
        this.getGroupExtension().addProjectToGroupById(groupId, projectId, addProjectToGroupByIdRequest);
        return ResponseEntity.ok((Object)new SuccessfulUpdate("Group updated successfully"));
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public ResponseEntity<Void> deleteProjectFromGroupById(Long groupId, Long projectId) {
        this.getGroupExtension().deleteProjectFromGroupById(groupId, projectId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private GroupExtensionPoint getGroupExtension() {
        return (GroupExtensionPoint)this.pluginManager.getExtensions(GroupExtensionPoint.class).stream().findFirst().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.PAYMENT_REQUIRED));
    }

    private ReportPortalUser getPrincipal() {
        return (ReportPortalUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }
}

