/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.api.ProjectsApi;
import com.epam.reportportal.api.model.AddProjectToGroupByIdRequest;
import com.epam.reportportal.api.model.ProjectGroupInfo;
import com.epam.reportportal.api.model.ProjectGroupsPage;
import com.epam.reportportal.api.model.SuccessfulUpdate;
import com.epam.ta.reportportal.core.group.GroupExtensionPoint;
import org.pf4j.PluginManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class GeneratedProjectController
implements ProjectsApi {
    private final PluginManager pluginManager;

    @Autowired
    public GeneratedProjectController(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')||hasRole('ADMINISTRATOR')")
    public ResponseEntity<ProjectGroupsPage> getGroupsOfProject(String projectName, Integer offset, Integer limit) {
        ProjectGroupsPage page = this.getGroupExtension().getProjectGroups(projectName, offset, limit);
        return ResponseEntity.ok((Object)page);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')||hasRole('ADMINISTRATOR')")
    public ResponseEntity<ProjectGroupInfo> getProjectGroupById(String projectName, Long groupId) {
        ProjectGroupInfo group = this.getGroupExtension().getProjectGroupById(projectName, groupId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return ResponseEntity.ok((Object)group);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public ResponseEntity<SuccessfulUpdate> addGroupToProjectById(String projectName, Long groupId, AddProjectToGroupByIdRequest addProjectToGroupByIdRequest) {
        this.getGroupExtension().addGroupToProject(projectName, groupId, addProjectToGroupByIdRequest);
        return ResponseEntity.ok((Object)new SuccessfulUpdate("Group updated successfully"));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    public ResponseEntity<Void> deleteGroupFromProjectById(String projectName, Long groupId) {
        this.getGroupExtension().deleteGroupFromProject(projectName, groupId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private GroupExtensionPoint getGroupExtension() {
        return (GroupExtensionPoint)this.pluginManager.getExtensions(GroupExtensionPoint.class).stream().findFirst().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.PAYMENT_REQUIRED));
    }
}

