/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.rules.exception.ErrorRS;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.exception.ExceptionMappings;
import com.epam.ta.reportportal.exception.forwarding.ClientResponseForwardingExceptionHandler;
import com.epam.ta.reportportal.exception.forwarding.ResponseForwardingException;
import com.epam.ta.reportportal.exception.rest.DefaultErrorResolver;
import com.epam.ta.reportportal.exception.rest.ReportPortalExceptionResolver;
import com.epam.ta.reportportal.exception.rest.RestError;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.RestClientException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@RestControllerAdvice(value={"com.epam.ta.reportportal.ws.controller"})
public class ErrorHandlingController {
    @Generated
    private static final Logger log = LogManager.getLogger(ErrorHandlingController.class);
    private final DefaultErrorResolver defaultErrorResolver = new DefaultErrorResolver(ExceptionMappings.DEFAULT_MAPPING);
    @Autowired
    private ReportPortalExceptionResolver reportPortalExceptionResolver;
    @Autowired
    ClientResponseForwardingExceptionHandler clientResponseForwardingExceptionHandler;

    @ExceptionHandler(value={MethodArgumentNotValidException.class, MethodArgumentTypeMismatchException.class, HttpMessageNotReadableException.class, MissingServletRequestPartException.class, MissingServletRequestParameterException.class, RestClientException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorRS handleCustomBadRequest(Exception exception) {
        return this.defaultErrorResolver.resolveError(exception).errorRs();
    }

    @ExceptionHandler(value={ReportPortalException.class})
    public ResponseEntity<ErrorRS> handle(ReportPortalException exception) {
        RestError rs = this.reportPortalExceptionResolver.resolveError((Exception)((Object)exception));
        return ResponseEntity.status((HttpStatusCode)rs.httpStatus()).body((Object)rs.errorRs());
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ErrorRS handle(AccessDeniedException exception) {
        return this.defaultErrorResolver.resolveError((Exception)exception).errorRs();
    }

    @ExceptionHandler(value={BadCredentialsException.class, LockedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ErrorRS handle(BadCredentialsException exception) {
        return this.defaultErrorResolver.resolveError((Exception)exception).errorRs();
    }

    @ExceptionHandler(value={ResponseForwardingException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseEntity<String> handle(ResponseForwardingException exception) {
        return this.clientResponseForwardingExceptionHandler.resolveException(exception);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorRS handle(Exception exception) {
        return this.defaultErrorResolver.resolveError(exception).errorRs();
    }
}

