/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email.strategy;

import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.util.email.strategy.AbstractEmailNotificationStrategy;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UserDeletionNotificationStrategy
extends AbstractEmailNotificationStrategy {
    @Autowired
    public UserDeletionNotificationStrategy(MailServiceFactory mailServiceFactory, ThreadPoolTaskExecutor emailExecutorService) {
        super(mailServiceFactory, emailExecutorService);
    }

    @Override
    public void sendEmail(String recipient, Map<String, Object> params) {
        try {
            this.emailExecutorService.execute(() -> this.mailServiceFactory.getDefaultEmailService(false).sendAccountDeletionByRetentionNotification(recipient));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to send email.", (Throwable)e);
        }
    }
}

