/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.util.UserUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.UrlEscapers;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class EmailService
extends JavaMailSenderImpl {
    private static final String FINISH_LAUNCH_EMAIL_SUBJECT = " ReportPortal Notification: [%s] launch '%s' #%s finished";
    private static final String URL_FORMAT = "%s/launches/all";
    private static final String COMPOSITE_ATTRIBUTE_FILTER_FORMAT = "%s?launchesParams=filter.has.compositeAttribute=%s";
    private static final String TEMPLATE_IMAGES_PREFIX = "templates/email/images/";
    private TemplateEngine templateEngine;
    private String rpHost;
    private InternetAddress from;

    public EmailService(Properties javaMailProperties) {
        super.setJavaMailProperties(javaMailProperties);
    }

    public void sendLaunchFinishNotification(String[] recipients, String url, Project project, Launch launch) {
        String subject = String.format(FINISH_LAUNCH_EMAIL_SUBJECT, project.getName().toUpperCase(), launch.getName(), launch.getNumber());
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            String text = this.mergeFinishLaunchText(this.getUrl(url), launch, project.getProjectIssueTypes());
            message.setText(text, true);
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    @VisibleForTesting
    String mergeFinishLaunchText(String url, Launch launch, Set<ProjectIssueType> projectIssueTypes) {
        HashMap<String, Object> email = new HashMap<String, Object>();
        String basicUrl = String.format(URL_FORMAT, url);
        email.put("name", launch.getName());
        email.put("number", String.valueOf(launch.getNumber()));
        email.put("description", launch.getDescription());
        email.put("url", String.format("%s/%s", basicUrl, launch.getId()));
        if (!CollectionUtils.isEmpty((Collection)launch.getAttributes())) {
            email.put("attributes", launch.getAttributes().stream().filter(it -> it.isSystem() == false).collect(Collectors.toMap(attribute -> Optional.ofNullable(attribute.getKey()).map(it -> it.concat(":")).orElse("").concat(attribute.getValue()), attribute -> this.buildAttributesLink(basicUrl, (ItemAttribute)attribute))));
        }
        Map<String, Integer> statistics = launch.getStatistics().stream().filter(s -> Optional.ofNullable(s.getStatisticsField()).isPresent() && StringUtils.isNotEmpty((CharSequence)s.getStatisticsField().getName())).collect(Collectors.toMap(s -> s.getStatisticsField().getName(), Statistics::getCounter, (prev, curr) -> prev));
        email.put("total", Optional.ofNullable(statistics.get("statistics$executions$total")).orElse(0));
        email.put("passed", Optional.ofNullable(statistics.get("statistics$executions$passed")).orElse(0));
        email.put("failed", Optional.ofNullable(statistics.get("statistics$executions$failed")).orElse(0));
        email.put("skipped", Optional.ofNullable(statistics.get("statistics$executions$skipped")).orElse(0));
        email.put("productBugTotal", Optional.ofNullable(statistics.get("statistics$defects$product_bug$total")).orElse(0));
        email.put("automationBugTotal", Optional.ofNullable(statistics.get("statistics$defects$automation_bug$total")).orElse(0));
        email.put("systemIssueTotal", Optional.ofNullable(statistics.get("statistics$defects$system_issue$total")).orElse(0));
        email.put("noDefectTotal", Optional.ofNullable(statistics.get("statistics$defects$no_defect$total")).orElse(0));
        email.put("toInvestigateTotal", Optional.ofNullable(statistics.get("statistics$defects$to_investigate$total")).orElse(0));
        Map<String, String> locatorsMapping = projectIssueTypes.stream().collect(Collectors.toMap(it -> it.getIssueType().getLocator(), it -> it.getIssueType().getLongName()));
        this.fillEmail(email, "pbInfo", statistics, locatorsMapping, "^statistics\\$defects\\$product_bug\\$((?!total$).)+.*$");
        this.fillEmail(email, "abInfo", statistics, locatorsMapping, "^statistics\\$defects\\$automation_bug\\$((?!total$).)+.*$");
        this.fillEmail(email, "siInfo", statistics, locatorsMapping, "^statistics\\$defects\\$system_issue\\$((?!total$).)+.*$");
        this.fillEmail(email, "ndInfo", statistics, locatorsMapping, "^statistics\\$defects\\$no_defect\\$((?!total$).)+.*$");
        this.fillEmail(email, "tiInfo", statistics, locatorsMapping, "^statistics\\$defects\\$to_investigate\\$((?!total$).)+.*$");
        return this.templateEngine.merge("finish-launch-template.ftl", email);
    }

    private String getUrl(String baseUrl) {
        return Optional.ofNullable(this.rpHost).map(rh -> {
            UriComponents rpHostUri = UriComponentsBuilder.fromUriString((String)rh).build();
            return UriComponentsBuilder.fromUriString((String)baseUrl).scheme(rpHostUri.getScheme()).host(rpHostUri.getHost()).port(rpHostUri.getPort()).build().toUri().toASCIIString();
        }).orElse(baseUrl);
    }

    private String buildAttributesLink(String basicUrl, ItemAttribute attribute) {
        if (null != attribute.getKey()) {
            return String.format(COMPOSITE_ATTRIBUTE_FILTER_FORMAT, basicUrl, UrlEscapers.urlPathSegmentEscaper().escape(attribute.getKey()) + ":" + UrlEscapers.urlPathSegmentEscaper().escape(attribute.getValue()));
        }
        return String.format(COMPOSITE_ATTRIBUTE_FILTER_FORMAT, basicUrl, UrlEscapers.urlPathSegmentEscaper().escape(attribute.getValue()));
    }

    private void fillEmail(Map<String, Object> email, String statisticsName, Map<String, Integer> statistics, Map<String, String> locatorsMapping, String regex) {
        Optional<Map<String, Integer>> pb = Optional.of(statistics.entrySet().stream().filter(entry -> {
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher((CharSequence)entry.getKey()).matches();
        }).collect(Collectors.toMap(entry -> (String)locatorsMapping.get(StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"$")), entry -> Optional.ofNullable((Integer)entry.getValue()).orElse(0), (prev, curr) -> prev)));
        pb.ifPresent(stats -> email.put(statisticsName, stats));
    }

    public void sendRestorePasswordEmail(String subject, String[] recipients, String url, String login) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("login", login);
            email.put("url", this.getUrl(url));
            String text = this.templateEngine.merge("restore-password-template.ftl", email);
            message.setText(text, true);
            message.addInline("restore-password.png", this.emailTemplateResource("restore-password.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendChangePasswordConfirmation(String subject, String[] recipients, String login) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("user_name", login);
            String text = this.templateEngine.merge("change-password-template.ftl", email);
            message.setText(text, true);
            message.addInline("illustration.png", this.emailTemplateResource("illustration.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendIndexFinishedEmail(String subject, String recipient, Long indexedLogsCount) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipient);
            HashMap<String, Long> email = new HashMap<String, Long>();
            email.put("indexedLogsCount", Optional.ofNullable(indexedLogsCount).orElse(0L));
            this.setFrom(message);
            String text = this.templateEngine.merge("index-finished-template.ftl", email);
            message.setText(text, true);
        };
        this.send(preparator);
    }

    public void setFrom(String from) {
        try {
            this.from = from.contains("<") ? new InternetAddress(from) : (UserUtils.isEmailValid((String)from) ? new InternetAddress(from, null) : null);
        }
        catch (AddressException | UnsupportedEncodingException e) {
            this.from = null;
        }
    }

    private void setFrom(MimeMessageHelper message) throws MessagingException {
        if (this.getFrom().isPresent()) {
            message.setFrom(this.getFrom().get());
        } else if (UserUtils.isEmailValid((String)this.getUsername())) {
            message.setFrom(this.getUsername());
        }
    }

    public Optional<InternetAddress> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public void sendCreateUserConfirmationEmail(String subject, String[] recipients, String url) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", this.getUrl(url));
            String text = this.templateEngine.merge("registration-template.ftl", email);
            message.setText(text, true);
            message.addInline("create-user.png", this.emailTemplateResource("create-user.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendCreateUserConfirmationEmail(CreateUserRQFull req, String basicUrl) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Welcome to ReportPortal");
            message.setTo(req.getEmail());
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", this.getUrl(basicUrl));
            email.put("login", EntityUtils.normalizeId((String)req.getLogin()));
            if (req.getPassword() != null) {
                email.put("password", req.getPassword());
                message.setText(this.templateEngine.merge("create-user-template.ftl", email), true);
            } else {
                message.setText(this.templateEngine.merge("create-user-identity-provider-template.ftl", email), true);
            }
            message.addInline("create-user.png", this.emailTemplateResource("create-user.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendConnectionTestEmail(boolean isNewIntegration) throws AddressException {
        InternetAddress sender = this.getFrom().orElseThrow(() -> new AddressException("Sender email address is not exist"));
        String subject = isNewIntegration ? "Email server integration creation" : "Email server integration updated";
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(sender);
            message.setFrom(sender);
            Map data = Collections.emptyMap();
            String text = this.templateEngine.merge("email-connection.ftl", data);
            message.setText(text, true);
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    private void attachSocialImages(MimeMessageHelper message) throws MessagingException {
        message.addInline("ic-twitter.png", this.emailTemplateResource("ic-twitter.png"));
        message.addInline("ic-slack.png", this.emailTemplateResource("ic-slack.png"));
        message.addInline("ic-youtube.png", this.emailTemplateResource("ic-youtube.png"));
        message.addInline("ic-linkedin.png", this.emailTemplateResource("ic-linkedin.png"));
        message.addInline("ic-facebook.png", this.emailTemplateResource("ic-facebook.png"));
        message.addInline("ic-github.png", this.emailTemplateResource("ic-github.png"));
    }

    private Resource emailTemplateResource(String resource) {
        return new FileUrlResource(Objects.requireNonNull(EmailService.class.getClassLoader().getResource(TEMPLATE_IMAGES_PREFIX + resource)));
    }

    public void sendAccountSelfDeletionNotification(String recipient) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Account Deletion Notification");
            message.setTo(recipient);
            this.setFrom(message);
            Map data = Collections.emptyMap();
            String text = this.templateEngine.merge("self-delete-account-template.ftl", data);
            message.setText(text, true);
            message.addInline("new-logo.png", this.emailTemplateResource("new-logo.png"));
            message.addInline("deleted-account.png", this.emailTemplateResource("deleted-account.png"));
            this.attachNewSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendAccountDeletionByRetentionNotification(String recipient) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Account Deletion Notification");
            message.setTo(recipient);
            this.setFrom(message);
            Map data = Collections.emptyMap();
            String text = this.templateEngine.merge("delete-account-template.ftl", data);
            message.setText(text, true);
            message.addInline("new-logo.png", this.emailTemplateResource("new-logo.png"));
            message.addInline("deleted-account.png", this.emailTemplateResource("deleted-account.png"));
            this.attachNewSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendUserExpirationNotification(String recipient, Map<String, Object> params) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Account Deletion Notification");
            message.setTo(recipient);
            this.setFrom(message);
            HashMap data = new HashMap();
            data.put("remainingTime", params.get("remainingTime"));
            data.put("inactivityPeriod", params.get("inactivityPeriod"));
            data.put("deadlineDate", params.get("deadlineDate"));
            String text = this.templateEngine.merge("delete-account-notification-template.ftl", data);
            message.setText(text, true);
            message.addInline("new-logo.png", this.emailTemplateResource("new-logo.png"));
            message.addInline("delete-account-notification.png", this.emailTemplateResource("delete-account-notification.png"));
            this.attachNewSocialImages(message);
        };
        this.send(preparator);
    }

    private void attachNewSocialImages(MimeMessageHelper message) throws MessagingException {
        message.addInline("new-ic-twitter.png", this.emailTemplateResource("new-ic-twitter.png"));
        message.addInline("new-ic-slack.png", this.emailTemplateResource("new-ic-slack.png"));
        message.addInline("new-ic-youtube.png", this.emailTemplateResource("new-ic-youtube.png"));
        message.addInline("new-ic-linkedin.png", this.emailTemplateResource("new-ic-linkedin.png"));
        message.addInline("new-ic-facebook.png", this.emailTemplateResource("new-ic-facebook.png"));
        message.addInline("new-ic-github.png", this.emailTemplateResource("new-ic-github.png"));
    }

    @Generated
    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    @Generated
    public void setRpHost(String rpHost) {
        this.rpHost = rpHost;
    }
}

