/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class SchemaFactory {
    private static final Map<Class<?>, Supplier<Schema>> schemas = new HashMap();

    public static Schema createSchemaForType(Class<?> type) {
        return Optional.ofNullable(schemas.get(type)).map(Supplier::get).orElse((Schema)new StringSchema());
    }

    static {
        schemas.put(String.class, StringSchema::new);
        schemas.put(Integer.class, IntegerSchema::new);
        schemas.put(Long.class, IntegerSchema::new);
        schemas.put(Boolean.class, BooleanSchema::new);
        schemas.put(Timestamp.class, DateSchema::new);
        schemas.put(Date.class, DateSchema::new);
        schemas.put(List.class, ArraySchema::new);
    }
}

