/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.GroupMembershipRepository;
import com.epam.ta.reportportal.dao.ProjectUserRepository;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectExtractor {
    private final ProjectUserRepository projectUserRepository;
    private final GroupMembershipRepository groupMembershipRepository;

    @Autowired
    public ProjectExtractor(ProjectUserRepository projectUserRepository, GroupMembershipRepository groupMembershipRepository) {
        this.projectUserRepository = projectUserRepository;
        this.groupMembershipRepository = groupMembershipRepository;
    }

    public ReportPortalUser.ProjectDetails extractProjectDetails(ReportPortalUser user, String projectName) {
        String normalizedProjectName = EntityUtils.normalizeId((String)projectName);
        if (user.getUserRole().equals((Object)UserRole.ADMINISTRATOR)) {
            return this.extractProjectDetailsAdmin(user, projectName);
        }
        return user.getProjectDetails().computeIfAbsent(normalizedProjectName, k -> this.findProjectDetails(user, normalizedProjectName).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"Please check the list of your available projects."})));
    }

    public Optional<ReportPortalUser.ProjectDetails> findProjectDetails(ReportPortalUser user, String projectName) {
        return this.projectUserRepository.findDetailsByUserIdAndProjectName(user.getUserId(), projectName).or(() -> this.groupMembershipRepository.findProjectDetails(user.getUserId(), projectName)).map(details -> {
            ArrayList<ProjectRole> projectRoles = new ArrayList<ProjectRole>(this.groupMembershipRepository.findUserProjectRoles(user.getUserId(), details.getProjectId()));
            projectRoles.add(details.getProjectRole());
            details.setHighestRole(projectRoles);
            return details;
        });
    }

    public ReportPortalUser.ProjectDetails extractProjectDetailsAdmin(ReportPortalUser user, String projectName) {
        if (user.getUserRole().getAuthority().equals(UserRole.ADMINISTRATOR.getAuthority())) {
            ReportPortalUser.ProjectDetails projectDetails = (ReportPortalUser.ProjectDetails)this.projectUserRepository.findAdminDetailsProjectName(EntityUtils.normalizeId((String)projectName)).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
            user.getProjectDetails().put(EntityUtils.normalizeId((String)projectName), projectDetails);
        }
        return Optional.ofNullable((ReportPortalUser.ProjectDetails)user.getProjectDetails().get(EntityUtils.normalizeId((String)projectName))).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"Please check the list of your available projects."}));
    }
}

