/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.core.configs.JsonSchemaValidatorConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.InputFormat;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JsonSchemaValidator {
    private final JsonSchemaFactory schemaFactory;

    @Autowired
    public JsonSchemaValidator(JsonSchemaValidatorConfig config) {
        this.schemaFactory = config.createSchemaFactory();
    }

    public Set<ValidationMessage> validate(String location, String input) throws IOException {
        JsonSchema schema = this.schemaFactory.getSchema(SchemaLocation.of((String)location));
        return schema.validate(input, InputFormat.JSON);
    }

    public Set<ValidationMessage> validate(String location, JsonNode input) throws IOException {
        JsonSchema schema = this.schemaFactory.getSchema(SchemaLocation.of((String)location));
        return schema.validate(input);
    }
}

