/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.handler;

import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.reporting.async.handler.ReportingMessageHandler;
import com.epam.ta.reportportal.reporting.async.message.MessageRetriever;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service
public class TestItemStartMessageHandler
implements ReportingMessageHandler {
    private final MessageRetriever retriever;
    private final StartTestItemHandler startTestItemHandler;
    private final ProjectExtractor projectExtractor;
    private final DatabaseUserDetailsService userDetailsService;

    public TestItemStartMessageHandler(MessageRetriever retriever, StartTestItemHandler startTestItemHandler, ProjectExtractor projectExtractor, DatabaseUserDetailsService userDetailsService) {
        this.retriever = retriever;
        this.startTestItemHandler = startTestItemHandler;
        this.projectExtractor = projectExtractor;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public void handleMessage(Message message) {
        Optional<StartTestItemRQ> startTestItemRQ = this.retriever.retrieveValid(message, StartTestItemRQ.class);
        Map headers = message.getMessageProperties().getHeaders();
        startTestItemRQ.ifPresent(rq -> {
            String username = (String)headers.get("username");
            String projectName = (String)headers.get("projectName");
            String parentId = (String)headers.get("parentItemId");
            ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
            ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, projectName);
            if (!Strings.isNullOrEmpty((String)parentId)) {
                this.startTestItemHandler.startChildItem(user, projectDetails, (StartTestItemRQ)rq, parentId);
            } else {
                this.startTestItemHandler.startRootItem(user, projectDetails, (StartTestItemRQ)rq);
            }
        });
    }
}

